/*
 * $Id: HTMLNodeFactoryImpl.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/07/30
 */
package feat2.template.impl;

import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.HTMLRemark;
import feat2.template.HTMLText;
import feat2.template.RemarkTextException;

/**
 * m[h̃t@NgNXB
 * @author SUGIMOTO Ken-ichi
 */
public class HTMLNodeFactoryImpl {

    //private static final Log log = LogFactory.getLog(HTMLNodeFactoryImpl.class);

    public static HTMLDocument createHTMLDocument() {
        return new HTMLElementImpl(true);
    }

    /**
     * ǂ̃c[ɂȂvfm[hB
     * @param tagName ^O̖O
     * @param endTag I^OKvȂtrue
     * @return
     */
    public static HTMLElement createHTMLElement(String tagName, boolean endTag) {
        return new HTMLElementImpl(tagName, true, endTag, false);
    }

    /**
     * ǂ̃c[ɂȂeLXgm[hB
     * @param text eLXgm[hɊi[镶B̓̕GXP[vBnullnĂ悢
     * @return
     */
    public static HTMLText createHTMLText(String text) {
        HTMLText ret = new HTMLTextImpl();
        ret.setRawText(text);
        return ret;
    }

    /**
     * ǂ̃c[ɂȂ߃m[hB
     * @param text ߃m[hɊi[镶BnullnĂ悢
     * @return
     * @throws RemarkTextException
     */
    public static HTMLRemark createHTMLRemark(String text) throws RemarkTextException {
        HTMLRemark ret = new HTMLRemarkImpl(text);
        return ret;
    }

}
