/*
 * $Id: SimpleControl.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/17
 */
package feat2.template.form;

import feat2.template.HTMLElement;

/**
 * valueɒlPȃtH[Rg[B
 * @author SUGIMOTO Ken-ichi
 */
public class SimpleControl implements FormControl {

    private int type;
    private HTMLElement element;

    SimpleControl(HTMLElement element, int type) {
        this.element = element;
        this.type = type;
    }

    public void setValue(String value) {
        if ( value != null )
            element.setAttribute("value", value);
        else
            element.removeAttribute("value");
    }

    public void setValues(String[] values) {
        if ( values != null && values.length > 0 )
            element.setAttribute("value", values[0]);
        else
            element.removeAttribute("value");
    }

    public String getValue() {
        return element.getAttribute("value");
    }

    public String[] getValues() {
        String value = element.getAttribute("value");
        if ( value != null )
            return new String[] {value};
        else
            return new String[0];
    }

    public HTMLElement getElement() {
        return element;
    }

    public int getType() {
        return type;
    }

}
