/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.apache.commons.collections.iterators.AbstractTestIterator;

public abstract class AbstractTestListIterator
extends AbstractTestIterator {
    public AbstractTestListIterator(String testName) {
        super(testName);
    }

    public abstract ListIterator makeEmptyListIterator();

    public abstract ListIterator makeFullListIterator();

    public Iterator makeEmptyIterator() {
        return this.makeEmptyListIterator();
    }

    public Iterator makeFullIterator() {
        return this.makeFullListIterator();
    }

    public boolean supportsAdd() {
        return true;
    }

    public boolean supportsSet() {
        return true;
    }

    public Object addSetValue() {
        return null;
    }

    public void testEmptyListIteratorIsIndeedEmpty() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        ListIterator it = this.makeEmptyListIterator();
        Assert.assertEquals((boolean)false, (boolean)it.hasNext());
        Assert.assertEquals((int)0, (int)it.nextIndex());
        Assert.assertEquals((boolean)false, (boolean)it.hasPrevious());
        Assert.assertEquals((int)-1, (int)it.previousIndex());
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException must be thrown from empty ListIterator");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            it.previous();
            Assert.fail((String)"NoSuchElementException must be thrown from empty ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testWalkForwardAndBack() {
        ArrayList list = new ArrayList();
        ListIterator it = this.makeFullListIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Assert.assertEquals((boolean)false, (boolean)it.hasNext());
        Assert.assertEquals((boolean)true, (boolean)it.hasPrevious());
        try {
            it.next();
            Assert.fail((String)"NoSuchElementException must be thrown from next at end of ListIterator");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        int i = list.size() - 1;
        while (i >= 0) {
            Assert.assertEquals((int)(i + 1), (int)it.nextIndex());
            Assert.assertEquals((int)i, (int)it.previousIndex());
            Object obj = list.get(i);
            Assert.assertEquals(obj, it.previous());
            --i;
        }
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Assert.assertEquals((boolean)false, (boolean)it.hasPrevious());
        try {
            it.previous();
            Assert.fail((String)"NoSuchElementException must be thrown from previous at start of ListIterator");
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
    }

    public void testAdd() {
        ListIterator it = this.makeFullListIterator();
        Object addValue = this.addSetValue();
        if (!this.supportsAdd()) {
            try {
                it.add(addValue);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        it = this.makeFullListIterator();
        it.add(addValue);
        Assert.assertEquals((Object)addValue, it.previous());
        it = this.makeFullListIterator();
        it.add(addValue);
        Assert.assertTrue((addValue != it.next() ? 1 : 0) != 0);
        it = this.makeFullListIterator();
        while (it.hasNext()) {
            it.next();
            it.add(addValue);
            Assert.assertEquals((Object)addValue, it.previous());
            it.next();
        }
    }

    public void testSet() {
        ListIterator it = this.makeFullListIterator();
        if (!this.supportsSet()) {
            try {
                it.set(this.addSetValue());
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        try {
            it.set(this.addSetValue());
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        it.next();
        it.set(this.addSetValue());
        it.set(this.addSetValue());
    }

    public void testRemoveThenSet() {
        ListIterator it = this.makeFullListIterator();
        if (this.supportsRemove() && this.supportsSet()) {
            it.next();
            it.remove();
            try {
                it.set(this.addSetValue());
                Assert.fail((String)"IllegalStateException must be thrown from set after remove");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void testAddThenSet() {
        ListIterator it = this.makeFullListIterator();
        if (this.supportsAdd() && this.supportsSet()) {
            it.next();
            it.add(this.addSetValue());
            try {
                it.set(this.addSetValue());
                Assert.fail((String)"IllegalStateException must be thrown from set after add");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void testAddThenRemove() {
        ListIterator it = this.makeFullListIterator();
        if (this.supportsAdd() && this.supportsRemove()) {
            it.next();
            it.add(this.addSetValue());
            try {
                it.remove();
                Assert.fail((String)"IllegalStateException must be thrown from remove after add");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

