/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.openjdk8.server;

import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenJDK8ServerALPNProcessor
implements ALPNProcessor.Server {
    private static final Logger LOG = Log.getLogger(OpenJDK8ServerALPNProcessor.class);

    public void init() {
        if (JavaVersion.VERSION.getPlatform() != 8) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
        if (ALPN.class.getClassLoader() != null) {
            throw new IllegalStateException(ALPN.class.getName() + " must be on JVM boot classpath");
        }
        if (LOG.isDebugEnabled()) {
            ALPN.debug = true;
        }
    }

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("sun.security.ssl.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        connection.addListener((Connection.Listener)new ALPNListener((ALPNServerConnection)connection));
    }

    private final class ALPNListener
    implements ALPN.ServerProvider,
    Connection.Listener {
        private final ALPNServerConnection alpnConnection;

        private ALPNListener(ALPNServerConnection connection) {
            this.alpnConnection = connection;
        }

        public void onOpened(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onOpened {}", new Object[]{this.alpnConnection});
            }
            ALPN.put((SSLEngine)this.alpnConnection.getSSLEngine(), (ALPN.Provider)this);
        }

        public void onClosed(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onClosed {}", new Object[]{this.alpnConnection});
            }
            ALPN.remove((SSLEngine)this.alpnConnection.getSSLEngine());
        }

        public void unsupported() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unsupported {}", new Object[]{this.alpnConnection});
            }
            this.alpnConnection.select(Collections.emptyList());
        }

        public String select(List<String> protocols) throws SSLException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("select {} {}", new Object[]{this.alpnConnection, protocols});
            }
            this.alpnConnection.select(protocols);
            return this.alpnConnection.getProtocol();
        }
    }
}

