/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.nosql.NoSqlSessionDataStore;
import org.eclipse.jetty.nosql.mongodb.MongoUtils;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.UnreadableSessionDataException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class MongoSessionDataStore
extends NoSqlSessionDataStore {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final String __METADATA = "__metadata__";
    public static final String __CONTEXT = "context";
    public static final String __VERSION = "__metadata__.version";
    public static final String __LASTSAVED = "__metadata__.lastSaved";
    public static final String __LASTNODE = "__metadata__.lastNode";
    public static final String __ACCESSED = "accessed";
    public static final String __LAST_ACCESSED = "lastAccessed";
    public static final String __EXPIRY = "expiry";
    public static final String __MAX_IDLE = "maxIdle";
    public static final String __CREATED = "created";
    public static final String __VALID = "valid";
    public static final String __ID = "id";
    private DBObject _version_1;
    private DBCollection _dbSessions;

    public void setDBCollection(DBCollection collection) {
        this._dbSessions = collection;
    }

    @ManagedAttribute(value="DBCollection", readonly=true)
    public DBCollection getDBCollection() {
        return this._dbSessions;
    }

    public SessionData load(final String id) throws Exception {
        final AtomicReference reference = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    DBObject sessionDocument = MongoSessionDataStore.this._dbSessions.findOne((DBObject)new BasicDBObject(MongoSessionDataStore.__ID, (Object)id));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("id={} loaded={}", new Object[]{id, sessionDocument});
                    }
                    if (sessionDocument == null) {
                        return;
                    }
                    Boolean valid = (Boolean)sessionDocument.get(MongoSessionDataStore.__VALID);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("id={} valid={}", new Object[]{id, valid});
                    }
                    if (valid == null || !valid.booleanValue()) {
                        return;
                    }
                    Object version = MongoUtils.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextSubfield(MongoSessionDataStore.__VERSION));
                    Long lastSaved = (Long)MongoUtils.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextSubfield(MongoSessionDataStore.__LASTSAVED));
                    String lastNode = (String)MongoUtils.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextSubfield(MongoSessionDataStore.__LASTNODE));
                    Long created = (Long)sessionDocument.get(MongoSessionDataStore.__CREATED);
                    Long accessed = (Long)sessionDocument.get(MongoSessionDataStore.__ACCESSED);
                    Long lastAccessed = (Long)sessionDocument.get(MongoSessionDataStore.__LAST_ACCESSED);
                    Long maxInactive = (Long)sessionDocument.get(MongoSessionDataStore.__MAX_IDLE);
                    Long expiry = (Long)sessionDocument.get(MongoSessionDataStore.__EXPIRY);
                    NoSqlSessionDataStore.NoSqlSessionData data = null;
                    DBObject sessionSubDocumentForContext = (DBObject)MongoUtils.getNestedValue(sessionDocument, MongoSessionDataStore.this.getContextField());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("attrs {}", new Object[]{sessionSubDocumentForContext});
                    }
                    if (sessionSubDocumentForContext != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Session {} present for context {}", new Object[]{id, MongoSessionDataStore.this._context});
                        }
                        data = (NoSqlSessionDataStore.NoSqlSessionData)MongoSessionDataStore.this.newSessionData(id, created, accessed, lastAccessed == null ? accessed : lastAccessed, maxInactive);
                        data.setVersion(version);
                        data.setExpiry(expiry);
                        data.setContextPath(MongoSessionDataStore.this._context.getCanonicalContextPath());
                        data.setVhost(MongoSessionDataStore.this._context.getVhost());
                        data.setLastSaved(lastSaved);
                        data.setLastNode(lastNode);
                        HashMap<String, Object> attributes = new HashMap<String, Object>();
                        for (String name : sessionSubDocumentForContext.keySet()) {
                            if (MongoSessionDataStore.__METADATA.equals(name)) continue;
                            String attr = MongoUtils.decodeName(name);
                            Object value = MongoUtils.decodeValue(sessionSubDocumentForContext.get(name));
                            attributes.put(attr, value);
                        }
                        data.putAllAttributes(attributes);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Session  {} not present for context {}", new Object[]{id, MongoSessionDataStore.this._context});
                    }
                    reference.set(data);
                }
                catch (Exception e) {
                    exception.set(new UnreadableSessionDataException(id, MongoSessionDataStore.this._context, (Throwable)e));
                }
            }
        };
        this._context.run(r);
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return (SessionData)reference.get();
    }

    public boolean delete(String id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove:session {} for context ", new Object[]{id, this._context});
        }
        BasicDBObject mongoKey = new BasicDBObject(__ID, (Object)id);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id));
        if (sessionDocument != null) {
            DBObject c = (DBObject)MongoUtils.getNestedValue(sessionDocument, __CONTEXT);
            if (c == null) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            Set contexts = c.keySet();
            if (contexts.isEmpty()) {
                this._dbSessions.remove((DBObject)mongoKey, WriteConcern.SAFE);
                return false;
            }
            if (contexts.size() == 1 && ((String)contexts.iterator().next()).equals(this.getCanonicalContextId())) {
                this._dbSessions.remove((DBObject)new BasicDBObject(__ID, (Object)id), WriteConcern.SAFE);
                return true;
            }
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put(this.getContextField(), (Object)1);
            remove.put("$unset", (Object)unsets);
            this._dbSessions.update((DBObject)mongoKey, (DBObject)remove, false, false, WriteConcern.SAFE);
            return true;
        }
        return false;
    }

    public boolean exists(String id) throws Exception {
        BasicDBObject fields = new BasicDBObject();
        fields.put(__EXPIRY, (Object)1);
        fields.put(__VALID, (Object)1);
        fields.put(this.getContextSubfield(__VERSION), (Object)1);
        DBObject sessionDocument = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id), (DBObject)fields);
        if (sessionDocument == null) {
            return false;
        }
        Boolean valid = (Boolean)sessionDocument.get(__VALID);
        if (!valid.booleanValue()) {
            return false;
        }
        Long expiry = (Long)sessionDocument.get(__EXPIRY);
        if (expiry > 0L && expiry < System.currentTimeMillis()) {
            return false;
        }
        Object version = MongoUtils.getNestedValue(sessionDocument, this.getContextSubfield(__VERSION));
        return version != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> doGetExpired(Set<String> candidates) {
        long now;
        long upperBound = now = System.currentTimeMillis();
        HashSet<String> expiredSessions = new HashSet<String>();
        BasicDBObject query = new BasicDBObject();
        query.append(__ID, (Object)new BasicDBObject("$in", candidates));
        query.append(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0).append("$lt", (Object)upperBound));
        try (DBCursor verifiedExpiredSessions = null;){
            verifiedExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)new BasicDBObject(__ID, (Object)1));
            for (DBObject session : verifiedExpiredSessions) {
                String id = (String)session.get(__ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo confirmed expired session {}", new Object[]{this._context, id});
                }
                expiredSessions.add(id);
            }
        }
        upperBound = this._lastExpiryCheckTime <= 0L ? now - 3L * (1000L * (long)this._gracePeriodSec) : this._lastExpiryCheckTime - 1000L * (long)this._gracePeriodSec;
        query = new BasicDBObject();
        BasicDBObject gt = new BasicDBObject(__EXPIRY, (Object)new BasicDBObject("$gt", (Object)0));
        BasicDBObject lt = new BasicDBObject(__EXPIRY, (Object)new BasicDBObject("$lt", (Object)upperBound));
        BasicDBList list = new BasicDBList();
        list.add((Object)gt);
        list.add((Object)lt);
        query.append("$and", (Object)list);
        try (DBCursor oldExpiredSessions = null;){
            BasicDBObject bo = new BasicDBObject(__ID, (Object)1);
            bo.append(__EXPIRY, (Object)1);
            oldExpiredSessions = this._dbSessions.find((DBObject)query, (DBObject)bo);
            for (DBObject session : oldExpiredSessions) {
                String id = (String)session.get(__ID);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} Mongo found old expired session {}", new Object[]{this._context, id + " exp=" + session.get(__EXPIRY)});
                }
                expiredSessions.add(id);
            }
        }
        for (String c : candidates) {
            if (expiredSessions.contains(c)) continue;
            try {
                if (this.exists(c)) continue;
                expiredSessions.add(c);
            }
            catch (Exception e) {
                LOG.warn("Problem checking potentially expired session {}", new Object[]{c, e});
            }
        }
        return expiredSessions;
    }

    public void initialize(SessionContext context) throws Exception {
        if (this.isStarted()) {
            throw new IllegalStateException("Context set after SessionDataStore started");
        }
        this._context = context;
        this.ensureIndexes();
    }

    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        BasicDBObject key = new BasicDBObject(__ID, (Object)id);
        BasicDBObject update = new BasicDBObject();
        boolean upsert = false;
        BasicDBObject sets = new BasicDBObject();
        BasicDBObject unsets = new BasicDBObject();
        Object version = ((NoSqlSessionDataStore.NoSqlSessionData)data).getVersion();
        if (lastSaveTime <= 0L) {
            upsert = true;
            version = new Long(1L);
            sets.put(__CREATED, (Object)data.getCreated());
            sets.put(__VALID, (Object)true);
            sets.put(this.getContextSubfield(__VERSION), version);
            sets.put(this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put(this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            sets.put(__MAX_IDLE, (Object)data.getMaxInactiveMs());
            sets.put(__EXPIRY, (Object)data.getExpiry());
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
        } else {
            sets.put(this.getContextSubfield(__LASTSAVED), (Object)data.getLastSaved());
            sets.put(this.getContextSubfield(__LASTNODE), (Object)data.getLastNode());
            version = new Long(((Number)version).longValue() + 1L);
            ((NoSqlSessionDataStore.NoSqlSessionData)data).setVersion(version);
            update.put("$inc", (Object)this._version_1);
            BasicDBObject fields = new BasicDBObject();
            fields.append(__MAX_IDLE, (Object)true);
            fields.append(__EXPIRY, (Object)true);
            DBObject o = this._dbSessions.findOne((DBObject)new BasicDBObject(__ID, (Object)id), (DBObject)fields);
            if (o != null) {
                long currentExpiry;
                Long tmpLong = (Long)o.get(__MAX_IDLE);
                long currentMaxIdle = tmpLong == null ? 0L : tmpLong;
                tmpLong = (Long)o.get(__EXPIRY);
                long l = currentExpiry = tmpLong == null ? 0L : tmpLong;
                if (currentMaxIdle != data.getMaxInactiveMs()) {
                    sets.put(__MAX_IDLE, (Object)data.getMaxInactiveMs());
                }
                if (currentExpiry != data.getExpiry()) {
                    sets.put(__EXPIRY, (Object)data.getExpiry());
                }
            } else {
                LOG.warn("Session {} not found, can't update", new Object[]{id});
            }
        }
        sets.put(__ACCESSED, (Object)data.getAccessed());
        sets.put(__LAST_ACCESSED, (Object)data.getLastAccessed());
        Set<String> names = ((NoSqlSessionDataStore.NoSqlSessionData)data).takeDirtyAttributes();
        if (lastSaveTime <= 0L) {
            names.addAll(((NoSqlSessionDataStore.NoSqlSessionData)data).getAllAttributeNames());
        }
        for (String name : names) {
            Object value = data.getAttribute(name);
            if (value == null) {
                unsets.put(this.getContextField() + "." + MongoUtils.encodeName(name), (Object)1);
                continue;
            }
            sets.put(this.getContextField() + "." + MongoUtils.encodeName(name), MongoUtils.encodeName(value));
        }
        if (!sets.isEmpty()) {
            update.put("$set", (Object)sets);
        }
        if (!unsets.isEmpty()) {
            update.put("$unset", (Object)unsets);
        }
        WriteResult res = this._dbSessions.update((DBObject)key, (DBObject)update, upsert, false, WriteConcern.SAFE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Save:db.sessions.update( {}, {},{} )", new Object[]{key, update, res});
        }
    }

    protected void ensureIndexes() throws MongoException {
        this._version_1 = new BasicDBObject(this.getContextSubfield(__VERSION), (Object)1);
        DBObject idKey = BasicDBObjectBuilder.start().add(__ID, (Object)1).get();
        this._dbSessions.createIndex(idKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        DBObject versionKey = BasicDBObjectBuilder.start().add(__ID, (Object)1).add("version", (Object)1).get();
        this._dbSessions.createIndex(versionKey, BasicDBObjectBuilder.start().add("name", (Object)"id_1_version_1").add("ns", (Object)this._dbSessions.getFullName()).add("sparse", (Object)false).add("unique", (Object)true).get());
        LOG.debug("done ensure Mongodb indexes existing", new Object[0]);
    }

    private String getContextField() {
        return "context." + this.getCanonicalContextId();
    }

    private String getCanonicalContextId() {
        return this.canonicalizeVHost(this._context.getVhost()) + ":" + this._context.getCanonicalContextPath();
    }

    private String canonicalizeVHost(String vhost) {
        if (vhost == null) {
            return "";
        }
        return vhost.replace('.', '_');
    }

    private String getContextSubfield(String attr) {
        return this.getContextField() + "." + attr;
    }

    @ManagedAttribute(value="does store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    public String toString() {
        return String.format("%s[collection=%s]", super.toString(), this.getDBCollection());
    }
}

