// $Id: plugin.cpp,v 1.4 2003/11/14 14:07:32 yuya Exp $

#include <ruby.h>
#include "exerb.h"
#include "plugin.h"
#include "utility.h"

////////////////////////////////////////////////////////////////////////////////

typedef struct {
	char *name;
	PLUGIN_PROC proc;
} PLUGIN_FUNCTION_ENTRY;

////////////////////////////////////////////////////////////////////////////////

extern VALUE rb_eExerbRuntimeError;

static int g_plugin_function_count = 0;
static PLUGIN_FUNCTION_ENTRY g_plugin_function_table[8] = {0};

////////////////////////////////////////////////////////////////////////////////

void
exerb_add_plugin_function(char *name, PLUGIN_PROC proc)
{
	if ( g_plugin_function_count > sizeof(g_plugin_function_table) / sizeof(PLUGIN_FUNCTION_ENTRY) ) {
		::rb_raise(rb_eExerbRuntimeError, "the plug-in function table is too big.");
	}

	g_plugin_function_table[g_plugin_function_count].name = ::exerb_strdup(name);
	g_plugin_function_table[g_plugin_function_count].proc = proc;
	g_plugin_function_count++;
}

PLUGIN_PROC
exerb_find_plugin_function(char *name)
{
	for ( int i = 0; i < g_plugin_function_count; i++ ) {
		if ( ::strcmp(g_plugin_function_table[i].name, name) == 0 ) {
			return g_plugin_function_table[i].proc;
		}
	}

	::rb_raise(rb_eExerbRuntimeError, "no such plugin function --- %s", name);

	return NULL;
}

bool
exerb_has_plugin_function(char *name)
{
	for ( int i = 0; i < g_plugin_function_count; i++ ) {
		if ( ::strcmp(g_plugin_function_table[i].name, name) == 0 ) {
			return true;
		}
	}

	return false;
}

////////////////////////////////////////////////////////////////////////////////
