
#==============================================================================#
# $Id: vs_fixed_file_info.rb,v 1.1 2003/11/19 19:30:54 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class VsFixedFileInfo < Base

        FORMAT = 'LLLLLLLLLLLLL'

        def initialize
          super()
          @signature          = nil
          @struct_version     = nil
          @file_version_ms    = nil
          @file_version_ls    = nil
          @product_version_ms = nil
          @product_version_ls = nil
          @file_flags_mask    = nil
          @file_flags         = nil
          @file_os            = nil
          @file_type          = nil
          @file_subtype       = nil
          @file_date_ms       = nil
          @file_date_ls       = nil
        end

        attr_accessor :signature, :struct_version, :file_version_ms, :file_version_ls, :product_version_ms, :product_version_ls, :file_flags_mask, :file_flags, :file_os, :file_type, :file_subtype, :file_date_ms, :file_date_ls

        def pack
          return [@signature, @struct_version, @file_version_ms, @file_version_ls, @product_version_ms, @product_version_ls, @file_flags_mask, @file_flags, @file_os, @file_type, @file_subtype, @file_date_ms, @file_date_ls].pack(FORMAT)
        end

        def unpack(bin)
          @signature, @struct_version, @file_version_ms, @file_version_ls, @product_version_ms, @product_version_ls, @file_flags_mask, @file_flags, @file_os, @file_type, @file_subtype, @file_date_ms, @file_date_ls = bin.unpack(FORMAT)
          return self
        end

        def file_version
          return format('%x.%x.%x.%x', @file_version_ms >> 16, @file_version_ms & 0x0000FFFF, @file_version_ls >> 16, @file_version_ls & 0x0000FFFF)
        end

        def product_version
          return format('%x.%x.%x.%x', @product_version_ms >> 16, @product_version_ms & 0x0000FFFF, @product_version_ls >> 16, @product_version_ls & 0x0000FFFF)
        end

      end # VsFixedFileInfo

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
