
#==============================================================================#
# $Id: image_resource_data_entry.rb,v 1.2 2003/11/18 17:51:12 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageResourceDataEntry < Base

        FORMAT = 'LLLL'

        def initialize
          super()
          @offset_to_data = nil
          @size           = nil
          @code_page      = nil
          @reserved       = nil
        end

        attr_accessor :offset_to_data, :size, :code_page, :reserved

        def pack
          return [@offset_to_data, @size, @code_page, @reserved].pack(FORMAT)
        end

        def unpack(bin)
          @offset_to_data, @size, @code_page, @reserved = bin.unpack(FORMAT)
          return self
        end

      end # ImageResourceDataEntry

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
