
#==============================================================================#
# $Id: executable.rb,v 1.19 2003/11/28 09:45:31 yuya Exp $
#==============================================================================#

require 'exerb/utility'
require 'exerb/archive'
require 'exerb/error'
require 'exerb/resource'
require 'exerb/win32/pe_file'

#==============================================================================#

module Exerb

  class Executable

    def initialize(core)
      @core = core
      @rsrc = Resource.new_from_pe_binary(@core)
    end

    attr_reader   :core
    attr_accessor :rsrc

    def self.new_from_file(path)
      return File.open(path, 'rb') { |file| self.new(file.read) }
    end

    def pack
      pe  = Win32::PeFile.new_from_binary(@core)
      fh  = pe.nt_headers.file_header
      oh  = pe.nt_headers.optional_header
      rsh = pe.sections.last
      raise(ExerbError, "the last section must be resource section") unless rsh.name == '.rsrc'

      packed_rsrc  = @rsrc.pack(rsh.virtual_address)
      aligned_rsrc = Utility.alignment4k(packed_rsrc)

      @core[rsh.pointer_to_raw_data, rsh.size_of_raw_data] = aligned_rsrc

      fh.time_date_stamp                 = Time.now.to_i
      oh.size_of_initialized_data        = oh.size_of_initialized_data - rsh.size_of_raw_data + aligned_rsrc.size
      oh.size_of_image                   = oh.size_of_image            - rsh.size_of_raw_data + aligned_rsrc.size
      oh.resource_directory_virtual_size = packed_rsrc.size
      rsh.virtual_size                   = packed_rsrc.size
      rsh.size_of_raw_data               = aligned_rsrc.size

      fh.update(@core)
      oh.update(@core)
      rsh.update(@core)

      return Utility.alignment16(@core)
    end

    def write_to(io)
      io.write(self.pack)
    end

    def write_to_file(filepath)
      File.open(filepath, 'wb') { |file| self.write_to(file) }
      File.chmod(0755, filepath)
    end

  end # Executable

end # Exerb

#==============================================================================#
#==============================================================================#
