
#==============================================================================#
# $Id: image_section_header.rb,v 1.2 2003/11/22 21:53:41 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/base'

#==============================================================================#

module Exerb

  module Win32

    module Struct

      class ImageSectionHeader < Base

        FORMAT = 'Z8LLLLLLSSL'

        def initialize
          @name                   = nil
          @virtual_size           = nil
          @virtual_address        = nil
          @size_of_raw_data       = nil
          @pointer_to_raw_data    = nil
          @pointer_to_relocations = nil
          @pointer_to_linenumbers = nil
          @number_of_relocations  = nil
          @number_of_linenumbers  = nil
          @characteristics        = nil
        end

        attr_accessor :name, :virtual_size, :virtual_address, :size_of_raw_data, :pointer_to_raw_data, :pointer_to_relocations, :pointer_to_linenumbers, :number_of_relocations, :number_of_linenumbers, :characteristics

        def pack
          return [@name, @virtual_size, @virtual_address, @size_of_raw_data, @pointer_to_raw_data, @pointer_to_relocations, @pointer_to_linenumbers, @number_of_relocations, @number_of_linenumbers, @characteristics].pack(FORMAT)
        end

        def unpack(bin)
          @name, @virtual_size, @virtual_address, @size_of_raw_data, @pointer_to_raw_data, @pointer_to_relocations, @pointer_to_linenumbers, @number_of_relocations, @number_of_linenumbers, @characteristics = bin.unpack(FORMAT)
          return self
        end

        alias :physical_address  :virtual_size
        alias :physical_address= :virtual_size=

      end # ImageSectionHeader

    end # Struct

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
