
#==============================================================================#
# $Id: icon_file.rb,v 1.2 2003/11/23 10:38:03 yuya Exp $
#==============================================================================#

require 'exerb/win32/struct/icon_header'
require 'exerb/win32/struct/icon_dir_entry'

#==============================================================================#

module Exerb

  module Win32

    class IconFile

      def initialize
        @entries = []
      end

      attr_accessor :entries

      def self.new_from_file(filepath)
        return File.open(filepath, 'rb') { |file| self.read(file) }
      end

      def self.read(io)
        return self.new.read(io)
      end

      def read(io)
        base = io.pos
        icon_header = Struct::IconHeader.read(io)

        @entries = (1..icon_header.count).collect {
          Struct::IconDirEntry.read(io)
        }.collect { |icon_dir_entry|
          io.seek(base + icon_dir_entry.image_offset)

          entry = Entry.new
          entry.width     = icon_dir_entry.width
          entry.height    = icon_dir_entry.height
          entry.bit_count = icon_dir_entry.bit_count
          entry.bit_count = 4 if entry.bit_count == 0 && icon_dir_entry.color_count == 16
          entry.bit_count = 8 if entry.bit_count == 0 && icon_dir_entry.bytes_in_res == 2216
          entry.bit_count = 8 if entry.bit_count == 0 && icon_dir_entry.bytes_in_res == 1384
          entry.value     = io.read(icon_dir_entry.bytes_in_res)
          entry
        }

        return self
      end

      class Entry

        def initialize
          @width     = nil
          @height    = nil
          @bit_count = nil
          @value     = nil
        end

        attr_accessor :width, :height, :bit_count, :value

      end # Entry

    end # IconFile

  end # Win32

end # Exerb

#==============================================================================#
#==============================================================================#
