
//////////////////////////////////////////////////////////////////////
// include

#include <windows.h>
#include <windowsx.h>
#include "ruby.h"
#include "win32/win32.h"
#include "exerb.h"
#include "resource.h"

//////////////////////////////////////////////////////////////////////
// pragma

#pragma comment(linker, "/section:.ruby,rw")
#pragma data_seg(".ruby")
	_declspec(dllexport) R2E_ARCHIVE_HEADER ArchiveHeader = {
		0x59425552, // Signature
		0x00000000, // TimeDateStamp
		0x00000000, // OffsetToName
		0x00000000, // NumberOfName
		0x00000000, // OffsetToScript
		0x00000000, // NumberOfScript
		0x00000000, // OffsetToDLL
		0x00000000, // NumberOfDLL
		0x00000000, // Options
	};
#pragma data_seg()

//////////////////////////////////////////////////////////////////////
// prototype

#ifdef _CONSOLE
#define CUI
#endif

#ifdef _WINDOWS
#define GUI
#endif

#ifdef CUI
int main(int argc, char** argv);
#endif

#ifdef GUI
int WINAPI WinMain(HINSTANCE hCurrentInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int iShowCmd);
#endif

static int   ExerbMain(int argc, char** argv);
static void  r2e_init_ruby(int argc, char** argv);
static void  ExerbReplaceRequire(void);
static bool  r2e_mapping(void);
static void  r2e_unmapping(void);
static bool  r2e_setup(void);
static int   r2e_execute(void);
static VALUE r2e_main(void);
static void  r2e_cleanup(void);
static void  r2e_final_ruby(void);
static int   r2e_fail(void);
static void  ExerbPrintStackTrace();
static LRESULT CALLBACK r2e_fail_dialog_proc(HWND hWnd, UINT uiMessage, WPARAM wParam, LPARAM lParam);
static void  r2e_error_message(LPSTR lpszMessage);
static void  r2e_inspect(VALUE valueObject);
static VALUE r2e_require_with_extension(VALUE valueFileName, char *pszExtension);
static VALUE r2e_require_without_extension(VALUE valueFileName);
static void  r2e_create_temporary_file(char *pszFilePathBuffer);
static void  r2e_get_import_address_table(DWORD dwDosHeader, DWORD *pdwAddress, DWORD *pdwDelta);
static PIMAGE_SECTION_HEADER r2e_get_enclosing_section_header(PIMAGE_NT_HEADERS pNtHeader, DWORD dwRVA);
static void  r2e_patch_import_address_table(VALUE valueOffset);
static void  r2e_dll_write_to_file(VALUE valueOffset, VALUE valueSize, char *pszFilePath);
static HMODULE r2e_load_dll(char *pszFilePath, VALUE valueFileName);
static VALUE r2e_init_function_name(VALUE valueFileName);
static VALUE r2e_require_dll(VALUE valueFileName, VALUE valueID);
static VALUE r2e_require_script(VALUE valueFileName, VALUE valueID);
static VALUE r2e_eval(VALUE valueString, VALUE valueFileName);
static void  ExerbGetSelfFilePath(LPSTR lpszBuffer, UINT uiBufferSize);
static void  ExerbGetSelfFileName(LPSTR lpszBuffer, UINT uiBufferSize);

static VALUE exerb_rb_require(VALUE valueObject, VALUE valueFileName);

//////////////////////////////////////////////////////////////////////
// extern

extern "C" VALUE ruby_errinfo;

//////////////////////////////////////////////////////////////////////
// typedef

typedef void (*INITPROC)(void);
typedef VALUE (__cdecl *RUBYFUNC)(...);

//////////////////////////////////////////////////////////////////////
// global variable

static HANDLE g_hFile        = NULL;
static HANDLE g_hFileMapping = NULL;
static DWORD  g_dwFileBase   = 0;
static PR2E_DOS_HEADER     g_pDOSHeader = NULL;
static PR2E_ARCHIVE_HEADER g_pArchive   = NULL;
static DWORD g_dwNameTableBase   = 0;
static DWORD g_dwScriptTableBase = 0;
static DWORD g_dwDllTableBase    = 0;

static const int g_ciDllTableMax  = 32;
static int       g_iDllTableIndex = 0;
static char      **g_ppszDllTable = new char*[g_ciDllTableMax];
static HMODULE   *g_hModuleTable  = new HMODULE[g_ciDllTableMax];

static VALUE g_hashName2ID           = 0;
static VALUE g_hashID2Name           = 0;
static VALUE g_hashScriptOffsetTable = 0;
static VALUE g_hashScriptSizeTable   = 0;
static VALUE g_hashDllOffsetTable    = 0;
static VALUE g_hashDllSizeTable      = 0;

#ifdef CUI
int
main(int argc, char** argv)
{
	return ExerbMain(argc, argv);
}
#endif

#ifdef GUI
int WINAPI
WinMain(HINSTANCE hCurrentInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int iShowCmd)
{
	return ExerbMain(0, NULL);
}
#endif

static int
ExerbMain(int argc, char** argv)
{
	int iResultCode = -1;

	::r2e_init_ruby(argc, argv); // Ruby
	::ExerbReplaceRequire();     // requireu
	
	if ( ::r2e_mapping() ) {               // gɃ}bv
		if ( ::r2e_setup() ) {             // s
			iResultCode = ::r2e_execute(); // s
			::r2e_final_ruby();            // t@CiCUĂяo
			::r2e_cleanup();               // N[Abv
		}
		::r2e_unmapping();                 // A}bv
	}

	return iResultCode;
}

static void
r2e_init_ruby(int argc, char** argv)
{
	::NtInitialize(&argc, &argv);
	::ruby_init();
	::ruby_set_argv(argc - 1, argv + 1);
}

static void
ExerbReplaceRequire(void)
{
	// requireu
	::rb_alias(rb_mKernel, ::rb_intern("__old_require__"), ::rb_intern("require"));
	::rb_define_global_function("require", (RUBYFUNC)exerb_rb_require, 1);
}

static bool
r2e_mapping(void)
{
	char szFilePath[MAX_PATH] = "";
	::ExerbGetSelfFilePath(szFilePath, sizeof(szFilePath));

	g_hFile = ::CreateFile(szFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if ( g_hFile == INVALID_HANDLE_VALUE ) {
		::r2e_error_message("t@C}bsOł܂BCreateFile֐̌ĂяoɎs܂B");
		return false;
	}

	g_hFileMapping = ::CreateFileMapping(g_hFile, NULL, PAGE_WRITECOPY, 0, 0, NULL);
	if ( !g_hFileMapping ) {
		::CloseHandle(g_hFile);
		::r2e_error_message("t@C}bsOł܂BCreateFileMapping֐̌ĂяoɎs܂B");
		return false;
	}

	g_dwFileBase = (DWORD)::MapViewOfFile(g_hFileMapping, FILE_MAP_COPY, 0, 0, 0);
	if ( !g_dwFileBase ) {
		::CloseHandle(g_hFileMapping);
		::CloseHandle(g_hFile);
		::r2e_error_message("t@C}bsOł܂BMapViewOfFile֐̌ĂяoɎs܂B");
		return false;
	}

	return true;
}

static void
r2e_unmapping(void)
{
	::UnmapViewOfFile((LPVOID)g_dwFileBase);
	::CloseHandle(g_hFileMapping);
	::CloseHandle(g_hFile);
}

static bool
r2e_setup(void)
{
	int i = 0;

	// A[JCuwb_̃ItZbgƃTCY`FbN
	g_pDOSHeader = (PR2E_DOS_HEADER)g_dwFileBase;
	if ( !g_pDOSHeader->OffsetToArchive || !g_pDOSHeader->SizeOfArchive ) {
		::r2e_error_message("A[JCuwb_܂BA[JCuĂȂRAs悤ƂĂ\܂B");
		return false;
	}

	// A[JCũXNvg`FbN
	g_pArchive = (PR2E_ARCHIVE_HEADER)(g_dwFileBase + g_pDOSHeader->OffsetToArchive);
	if ( g_pArchive->NumberOfScript == 0 ) {
		::r2e_error_message("sXNvg܂BA[JCuɂ͍Œ1̃XNvgKvłB");
		return false;
	}

	// ee[ũx[XAhXvZ
	g_dwNameTableBase   = (DWORD)g_pArchive + g_pArchive->OffsetToName;
	g_dwScriptTableBase = (DWORD)g_pArchive + g_pArchive->OffsetToScript;
	g_dwDllTableBase    = (DWORD)g_pArchive + g_pArchive->OffsetToDLL;

	// O[onbV𐶐
	g_hashName2ID           = ::rb_hash_new();
	g_hashID2Name           = ::rb_hash_new();
	g_hashScriptOffsetTable = ::rb_hash_new();
	g_hashScriptSizeTable   = ::rb_hash_new();
	g_hashDllOffsetTable    = ::rb_hash_new();
	g_hashDllSizeTable      = ::rb_hash_new();

	// O[oϐƂēo^
	::rb_global_variable(&g_hashName2ID);
	::rb_global_variable(&g_hashID2Name);
	::rb_global_variable(&g_hashScriptOffsetTable);
	::rb_global_variable(&g_hashScriptSizeTable);
	::rb_global_variable(&g_hashDllOffsetTable);
	::rb_global_variable(&g_hashDllSizeTable);

	// l[e[u̓enbVɊi[
	for ( i = 0; i < g_pArchive->NumberOfName; i++ ) {
		PR2E_NAME_HEADER pNameHeader = (PR2E_NAME_HEADER)(g_dwNameTableBase + sizeof(R2E_NAME_HEADER) * i);
		VALUE valueName = ::rb_str_new2((char*)(g_dwNameTableBase + pNameHeader->Offset));
		VALUE valueID   = INT2FIX(pNameHeader->ID);
		::rb_hash_aset(g_hashName2ID, valueName, valueID);
		::rb_hash_aset(g_hashID2Name, valueID, valueName);
	}

	// XNvge[u̓enbVɊi[
	for ( i = 0; i < g_pArchive->NumberOfScript; i++ ) {
		PR2E_SCRIPT_HEADER pScriptHeader = (PR2E_SCRIPT_HEADER)(g_dwScriptTableBase + sizeof(R2E_SCRIPT_HEADER) * i);
		VALUE valueID     = INT2FIX(pScriptHeader->NameID);
		VALUE valueOffset = INT2NUM(g_dwScriptTableBase + pScriptHeader->Offset);
		VALUE valueSize   = INT2NUM(pScriptHeader->Size);
		::rb_hash_aset(g_hashScriptOffsetTable, valueID, valueOffset);
		::rb_hash_aset(g_hashScriptSizeTable,   valueID, valueSize);
	}

	// Cue[u̓enbVɊi[
	for ( i = 0; i < g_pArchive->NumberOfDLL; i++ ) {
		PR2E_DLL_HEADER pDllHeader = (PR2E_DLL_HEADER)(g_dwDllTableBase + sizeof(R2E_DLL_HEADER) * i);
		VALUE valueID     = INT2FIX(pDllHeader->NameID);
		VALUE valueOffset = INT2NUM(g_dwDllTableBase + pDllHeader->Offset);
		VALUE valueSize   = INT2NUM(pDllHeader->Size);
		::rb_hash_aset(g_hashDllOffsetTable, valueID, valueOffset);
		::rb_hash_aset(g_hashDllSizeTable,   valueID, valueSize);
	}

	// R[hݒ
	switch ( g_pArchive->Options.Kcode ) {
	case EXERB_OPTIONS_KCODE_NONE: ::rb_set_kcode("n"); break; // NONE
	case EXERB_OPTIONS_KCODE_EUC:  ::rb_set_kcode("e"); break; // EUC
	case EXERB_OPTIONS_KCODE_SJIS: ::rb_set_kcode("s"); break; // Shift-JIS
	case EXERB_OPTIONS_KCODE_UTF8: ::rb_set_kcode("u"); break; // UTF-8
	}

	return true;
}

static int
r2e_execute(void)
{
	int state = 0;

	::rb_protect(r2e_main, 0, &state);

	if ( state ) {
		return ::r2e_fail();
	} else {
		return 0;
	}
}

static VALUE
r2e_main(void)
{
	PR2E_SCRIPT_HEADER pFirstScriptHeader = (PR2E_SCRIPT_HEADER)g_dwScriptTableBase;
	VALUE valueFirstScirptProgram = ::rb_str_new((char*)(g_dwScriptTableBase + pFirstScriptHeader->Offset), pFirstScriptHeader->Size);
	VALUE valueFirstScritpName    = ::rb_hash_aref(g_hashID2Name, INT2FIX(pFirstScriptHeader->NameID));
	::ruby_script(STR2CSTR(valueFirstScritpName));
	::r2e_eval(valueFirstScirptProgram, valueFirstScritpName);

	return Qnil;
}

static void
r2e_cleanup(void)
{
	// DLLe[uDLLAꎞt@C폜
	for ( int i = 0; i < g_iDllTableIndex; i++ ) {
		char *pszFilePath = g_ppszDllTable[i];
		HMODULE hModule   = g_hModuleTable[i];
		::FreeLibrary(hModule);
		::DeleteFile(pszFilePath);
		delete pszFilePath;
	}
}

static void
r2e_final_ruby(void)
{
	::ruby_finalize();
}

static int
r2e_fail(void)
{
	// O񂪐ݒ肳Ă邩ׂ
	if ( ruby_errinfo != Qnil ) {
		if ( rb_obj_is_kind_of(ruby_errinfo, rb_eSystemExit) == Qtrue ) {
			// SystemExit͖
			return 0;
		} else {
#ifdef GUI
			// SystemExitȊȌꍇ́A_CAO\ėO\
			::DialogBox(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_EXCEPTION), NULL, (DLGPROC)::r2e_fail_dialog_proc);
#endif
#ifdef CUI
			::ExerbPrintStackTrace();
#endif
			return -1;
		}
	} else {
		::r2e_error_message("O擾ł܂BO_CAO\邱Ƃł܂łB");
		return -1;
	}
}

static void
ExerbPrintStackTrace()
{
	VALUE type       = ::rb_funcall(::rb_funcall(ruby_errinfo, ::rb_intern("type"), 0), ::rb_intern("name"), 0);
	VALUE message    = ::rb_funcall(ruby_errinfo, ::rb_intern("message"), 0);
	VALUE backtrace  = ::rb_funcall(ruby_errinfo, ::rb_intern("backtrace"), 0);
	VALUE backtrace1 = ::rb_ary_shift(backtrace);
	VALUE backtrace2 = ::rb_str_concat(::rb_str_new2("\tfrom "), ::rb_ary_join(backtrace, ::rb_str_new2("\n\tfrom ")));

	::fprintf(stderr, "%s: %s (%s)\n", STR2CSTR(backtrace1), STR2CSTR(message), STR2CSTR(type));
	if ( FIX2INT(::rb_funcall(backtrace, ::rb_intern("size"), 0)) > 0 ) {
		::fprintf(stderr, "%s\n", STR2CSTR(backtrace2));
	}
}

static LRESULT CALLBACK
r2e_fail_dialog_proc(HWND hWnd, UINT uiMessage, WPARAM wParam, LPARAM lParam)
{
	switch ( uiMessage ) {
		case WM_INITDIALOG:
			// O̓e\
			if ( ruby_errinfo ) {
				VALUE valueType            = ::rb_funcall(ruby_errinfo, ::rb_intern("type"), 0);
				VALUE valueTypeName        = ::rb_funcall(valueType,    ::rb_intern("name"), 0);
				VALUE valueMessage         = ::rb_funcall(ruby_errinfo, ::rb_intern("message"), 0);
				VALUE valueMessageString   = ::rb_funcall(valueMessage, ::rb_intern("gsub"), 2, ::rb_str_new2("\n"), ::rb_str_new2("\r\n"));
				VALUE valueBacktrace       = ::rb_funcall(ruby_errinfo, ::rb_intern("backtrace"), 0);
				VALUE valueBacktraceString = ::rb_str_concat(::rb_ary_join(valueBacktrace, ::rb_str_new2("\r\n")), rb_str_new2("\r\n"));

				::SetDlgItemText(hWnd, IDC_EDIT_TYPE,      STR2CSTR(valueTypeName));
				::SetDlgItemText(hWnd, IDC_EDIT_MESSAGE,   STR2CSTR(valueMessageString));
				::SetDlgItemText(hWnd, IDC_EDIT_BACKTRACE, STR2CSTR(valueBacktraceString));
			}

			{
				// EBhE^Cgݒ
				char szWindowTitle[MAX_PATH] = "O - ";
				size_t length = strlen(szWindowTitle);
				::ExerbGetSelfFileName(szWindowTitle + length, sizeof(szWindowTitle) - length);
				::SetWindowText(hWnd, szWindowTitle);
			}

			{
				// eLXg{bNX̃tHgŒ蕝tHgɂ
				HFONT hFont = ::CreateFont(14, 0, 0, 0, FW_REGULAR, FALSE, FALSE, FALSE, SHIFTJIS_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, PROOF_QUALITY, FIXED_PITCH | FF_MODERN, "Terminal");
				SetWindowFont(::GetDlgItem(hWnd, IDC_EDIT_TYPE),      hFont, false);
				SetWindowFont(::GetDlgItem(hWnd, IDC_EDIT_MESSAGE),   hFont, false);
				SetWindowFont(::GetDlgItem(hWnd, IDC_EDIT_BACKTRACE), hFont, false);
			}

			// x炷
			::MessageBeep(MB_ICONHAND);

			return TRUE;
		case WM_CLOSE:
			// _CAO
			::EndDialog(hWnd, ID_CLOSE);
			return TRUE;
		case WM_COMMAND:
			switch ( LOWORD(wParam) ) {
				case ID_CLOSE:
					// _CAO
					::EndDialog(hWnd, ID_CLOSE);
					return TRUE;
			}
			break;
	}

	return FALSE;
}

static void
r2e_error_message(LPSTR lpszMessage)
{
	::MessageBox(NULL, lpszMessage, "Ruby", MB_ICONERROR);
}

// for debug
static void
r2e_inspect(VALUE valueObject)
{
	VALUE valueInspect = ::rb_inspect(valueObject);
	::OutputDebugString("inspect: ");
	::OutputDebugString(STR2CSTR(valueInspect));
	::OutputDebugString("\n");
}

static VALUE
r2e_require_with_extension(VALUE valueFileName, char *pszExtension)
{
	// t@C疼OID擾
	VALUE valueID = ::rb_hash_aref(g_hashName2ID, valueFileName);

	if ( valueID != Qnil ) {
		if ( ::strcmp(".rb", pszExtension) == 0 ) {
			// gq.rb̏ꍇ
			return ::r2e_require_script(valueFileName, valueID);
		} else if ( ::strcmp(".so", pszExtension) == 0 || ::strcmp(".dll", pszExtension) == 0 ) {
			// gq.so܂.dll̏ꍇ
			return ::r2e_require_dll(valueFileName, valueID);
		} else {
			// sȊgq̏ꍇ
			return Qfalse;
		}
	} else {
		// OID擾łȂꍇ
		return Qfalse;
	}
}

static VALUE
r2e_require_without_extension(VALUE valueFileName)
{
	VALUE valueID = Qnil;
	VALUE valueFileNameSO  = ::rb_str_concat(::rb_str_dup(valueFileName), ::rb_str_new2(".so"));
	VALUE valueFileNameDLL = ::rb_str_concat(::rb_str_dup(valueFileName), ::rb_str_new2(".dll"));
	VALUE valueFileNameRB  = ::rb_str_concat(::rb_str_dup(valueFileName), ::rb_str_new2(".rb"));

	if ( (valueID = ::rb_hash_aref(g_hashName2ID, valueFileNameSO)) != Qnil ) {
		// .soT
		return ::r2e_require_dll(valueFileNameSO, valueID);
	} else if ( (valueID = ::rb_hash_aref(g_hashName2ID, valueFileNameDLL)) != Qnil ) {
		// .dllT
		return ::r2e_require_dll(valueFileNameDLL, valueID);
	} else if ( (valueID = ::rb_hash_aref(g_hashName2ID, valueFileNameRB)) != Qnil ) {
		// .rbT
		return ::r2e_require_script(valueFileNameRB, valueID);
	} else {
		// Ȃ
		return Qfalse;
	}
}

static void
r2e_create_temporary_file(char *pszFilePathBuffer)
{
	char szTemporaryDirectoryPath[MAX_PATH];
	::GetTempPath(sizeof(szTemporaryDirectoryPath), szTemporaryDirectoryPath);
	::GetTempFileName(szTemporaryDirectoryPath, "ruby", 0, pszFilePathBuffer);
}

static void
r2e_get_import_address_table(DWORD dwDosHeader, DWORD *pdwAddress, DWORD *pdwDelta)
{
	PIMAGE_DOS_HEADER pDosHeader = (PIMAGE_DOS_HEADER)dwDosHeader;
	PIMAGE_NT_HEADERS pNtHeader  = (PIMAGE_NT_HEADERS)((DWORD)pDosHeader + pDosHeader->e_lfanew);
	DWORD dwImportTableRVA = pNtHeader->OptionalHeader.DataDirectory[IMAGE_DIRECTORY_ENTRY_IMPORT].VirtualAddress;

	PIMAGE_SECTION_HEADER pSection = ::r2e_get_enclosing_section_header(pNtHeader, dwImportTableRVA);
	if ( pSection ) {
		*pdwDelta   = pSection->VirtualAddress - pSection->PointerToRawData;
		*pdwAddress = dwImportTableRVA - *pdwDelta;
	} else {
		::rb_raise(rb_eLoadError, "C|[gAhXe[ȕCɎs܂B\nC|[g񂪊܂܂ꂽZNV܂B");
		*pdwDelta   = 0;
		*pdwAddress = 0;
	}
}

static PIMAGE_SECTION_HEADER
r2e_get_enclosing_section_header(PIMAGE_NT_HEADERS pNtHeader, DWORD dwRVA)
{
	PIMAGE_SECTION_HEADER pSection = (PIMAGE_SECTION_HEADER)((DWORD)pNtHeader + sizeof(IMAGE_NT_HEADERS));

	for ( int i = 0; i < pNtHeader->FileHeader.NumberOfSections; i++, pSection++ ) {
		if ( (dwRVA >= pSection->VirtualAddress) && (dwRVA < (pSection->VirtualAddress + pSection->Misc.VirtualSize)) ) {
			return pSection;
		}
	}

	return NULL;
}

static void
r2e_patch_import_address_table(VALUE valueOffset)
{
	// DOSwb_̃AhX擾
	DWORD dwDosHeader = NUM2INT(valueOffset);

	// C|[gAhXe[ũAhXƁAzAhXƐAhX̍擾
	DWORD dwImportTableAddress = 0;
	DWORD dwImportTableDelta   = 0;
	::r2e_get_import_address_table(dwDosHeader, &dwImportTableAddress, &dwImportTableDelta);

	// C|[gAhXe[u̍ŏ̗vf擾
	DWORD dwImportTableBase = dwDosHeader + dwImportTableAddress;
	PIMAGE_IMPORT_DESCRIPTOR pDescriptor = (PIMAGE_IMPORT_DESCRIPTOR)dwImportTableBase;

	// g̃t@C擾
	char szSelfFileName[MAX_PATH] = "";
	::ExerbGetSelfFileName(szSelfFileName, sizeof(szSelfFileName));

	// Ώۂ̃t@C
	const char *pszRubyDllName1 = "mswin32-ruby16.dll";
	const char *pszRubyDllName2 = "mingw32-ruby16.dll";
	const char *pszRubyDllName3 = "cygwin-ruby16.dll";

	// g̃t@C̒`FbN
	// Ώۂ蒷t@Cƃpb`𓖂Ă邱ƂłȂ
	if ( ::strlen(szSelfFileName) > ::strlen(pszRubyDllName1) ||
		 ::strlen(szSelfFileName) > ::strlen(pszRubyDllName2) ||
		 ::strlen(szSelfFileName) > ::strlen(pszRubyDllName3) ) {
		::rb_raise(rb_eLoadError, "C|[gAhXe[ȕCɎs܂B\nst@C̃t@C܂B");
	}

	// C|[gAhXe[uDLL
	while ( pDescriptor->Characteristics ) {
		char *pszName = (char*)(dwDosHeader + pDescriptor->Name - dwImportTableDelta);

		if ( ::strcmp(pszName, pszRubyDllName1) == 0 ||
			 ::strcmp(pszName, pszRubyDllName2) == 0 ||
			 ::strcmp(pszName, pszRubyDllName3) == 0 ) {
			::strcpy(pszName, szSelfFileName);
		}

		pDescriptor++;
	}
}

static void
r2e_dll_write_to_file(VALUE valueOffset, VALUE valueSize, char *pszFilePath)
{
	void  *pvBuffer = (void*)NUM2INT(valueOffset);
	DWORD dwSize    = NUM2INT(valueSize);
	DWORD dwWritten = 0;

	HANDLE hFile = ::CreateFile(pszFilePath, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	::WriteFile(hFile, pvBuffer, dwSize, &dwWritten, NULL);
	::CloseHandle(hFile);
}

static HMODULE
r2e_load_dll(char *pszFilePath, VALUE valueFileName)
{
	// DLLǂݍ
	HMODULE hModule = ::LoadLibraryEx(pszFilePath, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);
	DWORD   dwError = ::GetLastError();

	if ( hModule ) {
		// ǂݍݐ

		// ֐̃AhX擾
		VALUE valueInitFunctionName = ::r2e_init_function_name(valueFileName);
		DWORD dwInitProc = (DWORD)::GetProcAddress(hModule, STR2CSTR(valueInitFunctionName));

		if ( dwInitProc ) {
			// 擾
			INITPROC fpInitProc = (INITPROC)dwInitProc;
			(*fpInitProc)();
			return hModule;
		} else {
			// 擾s
			::FreeLibrary(hModule);
			::DeleteFile(pszFilePath);
			::rb_raise(rb_eLoadError, "gCu̓ǂݍ݂Ɏs܂B\ngCȕ֐̊֐AhX擾邱Ƃł܂B");
			return NULL;
		}
	} else {
		// ǂݍݎs

		::DeleteFile(pszFilePath);
		::rb_raise(rb_eLoadError, "gCu̓ǂݍ݂Ɏs܂B\nLoadLibraryEx֐̎sɎs܂B\nG[ԍ[%i]łB", dwError);
		return NULL;
	}
}

static VALUE
r2e_init_function_name(VALUE valueFileName)
{
	static VALUE id_basename = ::rb_intern("basename");
	static VALUE id_sub      = ::rb_intern("sub");

	// t@C珉֐擾
	VALUE valueBaseName     = ::rb_funcall(rb_cFile, id_basename, 1, valueFileName);
	VALUE valueRegexpString = ::rb_str_new2("(\\.so|\\.dll)$");
	VALUE valueRegexp       = ::rb_reg_new(RSTRING(valueRegexpString)->ptr, RSTRING(valueRegexpString)->len, 0);
	VALUE valueFeatureName  = ::rb_funcall(valueBaseName, id_sub, 2, valueRegexp, ::rb_str_new2(""));
	VALUE valueFunctionName = ::rb_str_concat(::rb_str_new2("Init_"), valueFeatureName);

	return valueFunctionName;
}

static VALUE
r2e_require_dll(VALUE valueFileName, VALUE valueID)
{
	// DLLւ̃ItZbgƃTCY擾
	VALUE valueOffset = ::rb_hash_aref(g_hashDllOffsetTable, valueID);
	VALUE valueSize   = ::rb_hash_aref(g_hashDllSizeTable,   valueID);

	if ( valueOffset != Qnil && valueSize != Qnil ) {
		// DLL
		::r2e_patch_import_address_table(valueOffset);

		// ꎞt@C쐬
		char szTemporaryFilePath[MAX_PATH];
		::r2e_create_temporary_file(szTemporaryFilePath);

		// DLLt@Cɏ
		::r2e_dll_write_to_file(valueOffset, valueSize, szTemporaryFilePath);

		// DLLǂݍ
		HMODULE hModule = ::r2e_load_dll(szTemporaryFilePath, valueFileName);
		if ( hModule ) {
			// DLLe[uɓo^
			g_hModuleTable[g_iDllTableIndex] = hModule;
			g_ppszDllTable[g_iDllTableIndex] = new char[::strlen(szTemporaryFilePath) + 1];
			::strcpy(g_ppszDllTable[g_iDllTableIndex], szTemporaryFilePath);
			g_iDllTableIndex++;
			if ( g_iDllTableIndex >= g_ciDllTableMax ) {
				::rb_raise(rb_eLoadError, "DLLe[u̍őTCY𒴂܂B\nDLLe[u̍őTCY[%i]łB", g_ciDllTableMax);
			}

			return Qtrue;
		} else {
			return Qfalse;
		}
	} else {
		return Qfalse;
	}
}

static VALUE
r2e_require_script(VALUE valueFileName, VALUE valueID)
{
	VALUE valueOffset = ::rb_hash_aref(g_hashScriptOffsetTable, valueID);
	VALUE valueSize   = ::rb_hash_aref(g_hashScriptSizeTable,   valueID);

	if ( valueOffset != Qnil && valueSize != Qnil ) {
		VALUE valueScript = ::rb_str_new((char*)(NUM2INT(valueOffset)), NUM2INT(valueSize));
		::r2e_eval(valueScript, valueFileName);
		return Qtrue;
	} else {
		::rb_raise(rb_eLoadError, "XNvgsł܂BIDsłB");
		return Qfalse;
	}
}

static void
ExerbGetSelfFilePath(LPSTR lpszBuffer, UINT uiBufferSize)
{
	::GetModuleFileName(NULL, lpszBuffer, uiBufferSize);
}

static void
ExerbGetSelfFileName(LPSTR lpszBuffer, UINT uiBufferSize)
{
	char szSelfFilePath[MAX_PATH]     = "";
	char szSelfFilePathTemp[MAX_PATH] = "";
	char *lpszSelfFileName            = NULL;

	::ExerbGetSelfFilePath(szSelfFilePath, sizeof(szSelfFilePath));
	::GetFullPathName(szSelfFilePath, sizeof(szSelfFilePathTemp), szSelfFilePathTemp, &lpszSelfFileName);
	::strncpy(lpszBuffer, lpszSelfFileName, uiBufferSize);
}

static VALUE
r2e_eval(VALUE valueString, VALUE valueFileName)
{
	static VALUE id_eval      = ::rb_intern("eval");
	static VALUE valueBinding = ::rb_const_get(rb_mKernel, ::rb_intern("TOPLEVEL_BINDING"));
	static VALUE valueLine    = INT2FIX(1);
	return ::rb_funcall(rb_mKernel, id_eval, 4, valueString, valueBinding, valueFileName, valueLine);
}

static VALUE
exerb_rb_require(VALUE valueObject, VALUE valueFileName)
{
	// ɓǂݍ܂ĂAtrueԂďI
	VALUE valueFeatures = ::rb_gv_get("$\"");
	if ( ::rb_ary_includes(valueFeatures, valueFileName) == Qtrue ) {
		return Qfalse;
	}

	// gq擾
	char *pszFileName  = STR2CSTR(valueFileName);
	char *pszExtension = ::strrchr(pszFileName, '.');

	if ( pszExtension ) {
		// gqw肳Ăꍇ
		if ( ::r2e_require_with_extension(valueFileName, pszExtension) == Qtrue ) {
			::rb_ary_push(valueFeatures, valueFileName);
			return Qtrue;
		}
	} else {
		// gqw肳ĂȂꍇ
		if ( ::r2e_require_without_extension(valueFileName) == Qtrue ) {
			::rb_ary_push(valueFeatures, valueFileName);
			return Qtrue;
		}
	}

	static VALUE id_require = ::rb_intern("__old_require__");
	return ::rb_funcall(rb_mKernel, id_require, 1, valueFileName);
}
