
// Options - Kanji Code
#define EXERB_OPTIONS_KCODE_NONE  0
#define EXERB_OPTIONS_KCODE_EUC   1
#define EXERB_OPTIONS_KCODE_SJIS  2
#define EXERB_OPTIONS_KCODE_UTF8  3


typedef struct {
    WORD   Signature;                     // 00 - Magic number
    WORD   LastPageSize;                  // 02 - Bytes on last page of file
    WORD   TotalPagesInFile;              // 04 - Pages in file
    WORD   RelocationItems;               // 06 - Relocations
    WORD   ParagraphsInHeader;            // 08 - Size of header in paragraphs
    WORD   MinimumExtraParagraphs;        // 0A - Minimum extra paragraphs needed
    WORD   MaximumExtraParagraphs;        // 0C - Maximum extra paragraphs needed
    WORD   InitialStackSegment;           // 0E - Initial (relative) SS value
    WORD   InitialStackPointer;           // 10 - Initial SP value
    WORD   ComplementedChecksum;          // 12 - Checksum
    WORD   InitialInstructionPointer;     // 14 - Initial IP value
    WORD   InitialCodeSegment;            // 16 - Initial (relative) CS value
    WORD   RelocationTableOffset;         // 18 - File address of relocation table
    WORD   OverlayNumber;                 // 1A - Overlay number
    WORD   Reserved11;                    // 1C - Reserved words
    WORD   Reserved12;                    // 1E - Reserved words
    WORD   Reserved13;                    // 20 - Reserved words
    WORD   Reserved14;                    // 22 - Reserved words
    WORD   OEMIdentifier;                 // 24 - OEM identifier (for e_oeminfo)
    WORD   OEMInformation;                // 26 - OEM information; e_oemid specific
    WORD   Reserved21;                    // 28 - Reserved words
    WORD   Reserved22;                    // 2A - Reserved words
    WORD   Reserved23;                    // 2C - Reserved words
    WORD   Reserved24;                    // 2E - Reserved words
    WORD   Reserved25;                    // 30 - Reserved words
    WORD   Reserved26;                    // 32 - Reserved words
    DWORD  OffsetToArchive;               // 34 - Reserved words
    DWORD  SizeOfArchive;                 // 38 - Reserved words
    LONG   OffsetToNewHeader;             // 3C - File address of new exe header
} R2E_DOS_HEADER, *PR2E_DOS_HEADER;

typedef struct {
	DWORD Signature;                        // 00 - 0x59425552 "RUBY"
	DWORD TimeDateStamp;                    // 04 - 
	DWORD OffsetToName;                     // 08 - 
	DWORD NumberOfName;                     // 0C - 
	DWORD OffsetToScript;                   // 10 - 
	DWORD NumberOfScript;                   // 14 - 
	DWORD OffsetToDLL;                      // 18 - 
	DWORD NumberOfDLL;                      // 1C - 
	union {
		DWORD All;
		struct {
			DWORD Kcode:2;
			DWORD Reserved:30;
		};
	} Options;
} R2E_ARCHIVE_HEADER, *PR2E_ARCHIVE_HEADER;

typedef struct {
	DWORD ID;      // 00 - 
	DWORD Offset;  // 04 - 
	DWORD Size;    // 08 - 
} R2E_NAME_HEADER, *PR2E_NAME_HEADER;

typedef struct {
	DWORD NameID;  // 00 - 
	DWORD Offset;  // 04 - 
	DWORD Size;    // 08 - 
} R2E_SCRIPT_HEADER, *PR2E_SCRIPT_HEADER;

typedef struct {
	DWORD NameID;  // 00 - 
	DWORD Offset;  // 04 - 
	DWORD Size;    // 08 - 
} R2E_DLL_HEADER, *PR2E_DLL_HEADER;
