
#==============================================================================#
# exerb/archive.rb
# $Id: archive.rb,v 1.12 2003/05/06 04:14:05 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # Archive Class
  class Archive

    def initialize
      @kcode   = 'none'
      @entries = []
    end

    def set_kcode(kcode)
      @kcode = kcode
    end

    def add_script(name, filepath)
      @entries << EntryFile.new(name, ArchiveHeader::ENTRY_TYPE_SCRIPT, filepath)
    end

    def add_library(name, filepath)
      @entries << EntryFile.new(name, ArchiveHeader::ENTRY_TYPE_LIBRARY, filepath)
    end

    def add_binary(name, filepath)
      if /\.rb$/i =~ filepath
        @entries << BinaryEntryFile.new(name.sub(/\.rb$/i, '.brb'), ArchiveHeader::ENTRY_TYPE_BINARY, filepath)
      else
        @entries << EntryFile.new(name, ArchiveHeader::ENTRY_TYPE_BINARY, filepath)
      end
    end

    def pack
      name_table  = NameTable.new
      entry_table = EntryTable.new

      @entries.each { |entry|
        entry_table.add(name_table.add(entry.name), entry.type, entry.pack)
      }

      packed_name_table   = name_table.pack
      packed_entry_table  = entry_table.pack

      archive_header = ArchiveHeader.new
      archive_header.signature        = 'RUBY'
      archive_header.time_date_stamp  = Time.now.to_i
      archive_header.offset_to_name   = ArchiveHeader.size
      archive_header.number_of_name   = name_table.size
      archive_header.offset_to_entry  = ArchiveHeader.size + packed_name_table.size
      archive_header.number_of_entry  = entry_table.size

      archive_header.options = case @kcode
                               when 'none' then ArchiveHeader::OPTIONS_KCODE_NONE
                               when 'euc'  then ArchiveHeader::OPTIONS_KCODE_EUC
                               when 'sjis' then ArchiveHeader::OPTIONS_KCODE_SJIS
                               when 'utf8' then ArchiveHeader::OPTIONS_KCODE_UTF8
                               else raise 'Unknown char-set'
                               end

      return archive_header.pack + packed_name_table + packed_entry_table
    end

    def output(io)
      io.print(self.pack)
    end

    def output_to_file(filepath)
      File.open(filepath, 'wb') { |file|
        self.output(file)
      }
    end

    #==========================================================================#
    # EntryFile Class
    class EntryFile

      def initialize(name, type, filepath)
        @name     = name
        @type     = type
        @filepath = filepath
      end

      attr_reader :name, :type, :filepath

      def pack
        return File.open(filepath, 'rb') { |file| file.read }
      end

    end # EntryFile

    #==========================================================================#
    # BinaryEntryFile Class
    class BinaryEntryFile < EntryFile

      def pack
        require 'bruby'
        return BRb.dumpfile(filepath)
      end

    end # EntryFile

  end # Archive

end # Exerb

#==============================================================================#
#==============================================================================#
