
#==============================================================================#
# $Id: mkexy.rb,v 1.2 2004/03/25 09:35:25 yuya Exp $
#==============================================================================#

require 'exerb/utility2'

#==============================================================================#

BEGIN {
  $exerb_pwd = Dir.pwd
}

END {
  Dir.chdir($exerb_pwd)

  reject_list = [File.expand_path(__FILE__)]
  file_list   = [['script', $0, $0]] + Exerb::Utility2.loaded_features(reject_list)
  recipe_file = File.expand_path($0).sub(/(\.rb$|$)/i, '.exy')

  File.open(recipe_file, 'w') { |file|
    file.puts("# Generated by mkexy")
    file.puts("# on #{Time.now.strftime('%Y-%m-%d %H:%M')}")
    file.puts("")
    file.puts("general:")
    file.puts("  startup: #{$0}")
    file.puts("  core: cui")
    file.puts("  kcode: #{$KCODE.downcase}")
    file.puts("")
    file.puts("file:")
    file_list.each { |type, filename, filepath|
      file.puts("  #{filename}:")
      file.puts("    file: #{filepath}") if filename != filepath
      file.puts("    type: #{type}") if type != "script"
    }
  }
}

#==============================================================================#
#==============================================================================#
