=begin

$Id: recipe.en.rd,v 1.6 2003/02/21 02:59:30 yuya Exp $

= Exerb - Recipe file

* ((<1. Overview>))
* ((<2. Example of description>))
* ((<3. Format>))
  * ((<3.1. Comment>))
  * ((<3.2. Character specification>))
  * ((<3.3. Name of core specification>))
  * ((<3.4. File of core specification>))
  * ((<3.5. Output name specification>))
  * ((<3.6. Compress specification>))
  * ((<3.7. Ruby script definition>))
  * ((<3.8. Extension library definition>))
  * ((<3.9. bRuby binary code definition>))

== 1. Overview

The recipe file is a text file which the internal names and the file names
of scripts/extension-library to store in the executable file is specified.
The execution begin with a script is specified first in the recipe file.
"rbc" is recommended as an extension of the recipe file.

== 2. Example of description

  # example
  kcode		sjis
  script	foo.rb
  script	bar.rb		src/bar.rb
  library	Win32API.so	lib/Win32API.so

== 3. Format

The format of the recipe file is as follows.
<tab> is one or more tab characters.

=== 3.1. Comment

The line begins with "#" is a comment.

=== 3.2. Character specification

((*kcode*)) is the specification of the character set.

  kcode <code>

You can have a choice from none, euc, sjis or utf8 as ((|code|)).

=== 3.3. Name of core specification

((*corename*)) is specification of a core by the name.

  corename <name>

=== 3.4. File of core specification

((*corefile*)) is specification of a core by the path.

  corefile <path>

=== 3.5. Output name specification

((*output*)) is specification of output file name.

  output <path>

=== 3.6. Compress specification

((*compress*)) is specification of archive compression.

  compress <bool>

=== 3.7. Ruby script definition

((*script*)) is a definition of a Ruby script file.

  script <internal_name> [<path>]

((|internal_name|)) is a file name when it was stored in the archive file.
That is used by require, back tracing and other.

((|path|)) is a file name of script which is stored actually.
This file name should be specified by a relative path from the recipe file, or
an absolute path.

=== 3.8. Extension library definition

((*library*)) is a definition of an extension-library.

  library <internal_name> [<path>]

((|internal_name|)) and ((|path|)) are same as the
((<3.7. Ruby script definition>)).

=== 3.9. bRuby binary code definition

((*binary*)) is a definition of a bRuby binary code.

  binary <internal_name> [<path>]

((|internal_name|)) and ((|path|)) are same as the
((<3.7. Ruby script definition>)).

=end
