
#==============================================================================#
# exerb/archive.rb
# $Id: archive.rb,v 1.10 2003/01/17 05:57:50 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # Archive Class
  class Archive

    #==========================================================================#
    # Initialize Method

    def initialize
      @kcode   = 'none'
      @entries = []
    end

    #==========================================================================#
    # Instance Methods

    def set_kcode(kcode)
      @kcode = kcode
    end

    def add_script(name, filepath)
      @entries << EntryFile.new(name, ArchiveHeader::ENTRY_TYPE_SCRIPT, filepath)
    end

    def add_library(name, filepath)
      @entries << EntryFile.new(name, ArchiveHeader::ENTRY_TYPE_LIBRARY, filepath)
    end

    def add_binary(name, filepath)
      @entries << EntryFile.new(name, ArchiveHeader::ENTRY_TYPE_BINARY, filepath)
    end

    def pack
      name_table  = NameTable.new
      entry_table = EntryTable.new

      @entries.each { |entry|
        entry_table.add(name_table.add(entry.name), entry.type, entry.pack)
      }

      packed_name_table   = name_table.pack
      packed_entry_table  = entry_table.pack

      archive_header = ArchiveHeader.new
      archive_header.signature        = 'RUBY'
      archive_header.time_date_stamp  = Time.now.to_i
      archive_header.offset_to_name   = ArchiveHeader.size
      archive_header.number_of_name   = name_table.size
      archive_header.offset_to_entry  = ArchiveHeader.size + packed_name_table.size
      archive_header.number_of_entry  = entry_table.size

      archive_header.options = case @kcode
                               when 'none' then ArchiveHeader::OPTIONS_KCODE_NONE
                               when 'euc'  then ArchiveHeader::OPTIONS_KCODE_EUC
                               when 'sjis' then ArchiveHeader::OPTIONS_KCODE_SJIS
                               when 'utf8' then ArchiveHeader::OPTIONS_KCODE_UTF8
                               else raise 'Unknown char-set'
                               end

      return archive_header.pack + packed_name_table + packed_entry_table
    end

    def output(io)
      io.print(self.pack)
    end

    def output_to_file(filepath)
      File.open(filepath, 'wb') { |file|
        self.output(file)
      }
    end

    #==========================================================================#
    # EntryFile Class
    class EntryFile

      #========================================================================#
      # Initialize Method

      def initialize(name, type, filepath)
        @name     = name
        @type     = type
        @filepath = filepath
      end

      #========================================================================#
      # Accessor

      attr_reader :name, :type, :filepath

      #========================================================================#
      # Instance Methods

      def pack
        return File.open(filepath, 'rb') { |file| file.read }
      end

    end # EntryFile

  end # Archive

end # Exerb

#==============================================================================#
#==============================================================================#
