
#==============================================================================#
# exerb/dlltable.rb
# $Id: dlltable.rb,v 1.4 2002/09/20 09:12:12 yuya Exp $
#==============================================================================#

#==============================================================================#
# Exerb Module
module Exerb

  #============================================================================#
  # DLLTable Class
  class DLLTable

    #==========================================================================#
    # Initialize Method

    def initialize
      @dll = []
    end

    #==========================================================================#
    # Instance Methods

    def add(name_id, data)
      @dll << Item.new(name_id, data)
    end

    def size
      return @dll.size
    end

    def pack
      header_size = DLLHeader.size * @dll.size
      header = ''
      table  = ''

      @dll.each { |dll|
        dll_header = DLLHeader.new
        dll_header.name_id = dll.name_id
        dll_header.offset  = header_size + table.size
        dll_header.size    = dll.size

        header << dll_header.pack
        table  << dll.pack
      }

      return header + table
    end

    #==========================================================================#
    # Item Class
    class Item

      #========================================================================#
      # Initialize Method

      def initialize(name_id, data)
        @name_id = name_id
        @data    = data
      end

      #========================================================================#
      # Accessor

      attr_reader :name_id, :data

      #========================================================================#
      # Instance Methods

      def size
        return @data.size
      end

      def pack
        return @data + "\0"
      end

    end # Item

  end # DLLTable

end # Exerb

#==============================================================================#
#==============================================================================#
