=begin

= Exerb

== Overview

Exerb is the software which converts scripts/extension-libraries of the object
oriented language Ruby into a 32 bits Windows executable (is called the
executable file in this document) file which can execute alone and independently.

== Features

The main features of Exerb are as follows.

* Exerb can convert a number of files(script, extension-library) into a
  executable file in one piece.
* A executable file which is created by Exerb can execute on an environment
  Ruby is not installed, because the executable file contains Ruby.
* Any compiler is not needed to create an executable file.

== Installation

Run following commands to install Exerb.
You may need an administrator's authority to run "install".

  $ ruby install.rb config
  $ ruby install.rb setup
  # ruby install.rb install

== Example of use

(1) First, prepare a script which you want to convert.

      $ cat foo.rb
      puts 'ok'

(2) Make sure the script can run by Ruby.

      $ ruby foo.rb
      ok

(3) Prepare a definition file.

Automatically:

      $ ruby -r exerb/mkrbc foo.rb

Manually:

      $ cat foo.rbc
      script	foo.rb	foo.rb

(4) Create an executable file.

      $ exerb.rb foo.rbc

(5) Run the executable file which has been created.

      $ foo.exe
      ok

(6) If you see "ok", you succeeded.

== Options

You can specify following options.

: -c
: --corename
    Specify the core by name. If no core specified, "cui" is used as default.
    The names is defined in lib/exerb/config.rb, "cui" and "gui" are defined as
    the standard.
    This option is specified with -C at same time, -C option takes precedence.

: -C
: --corepath
    Specify the core by file name.
    This option is specified with -c at same time, -C option takes precedence.

: -o
: --output
    Specify the file name of the executable file will be created.
    If it is not specified, a file name which the rbc file's extension is
    replaced by "exe" is used. If the extension is not "rbc", ".exe" is
    appended.

: -h
: --help
    Display the help.

== Specification file

The definition file is a text file which the internal names and the file names
of scripts/extension-library to store in the executable file is specified.
The execution begin with a script is specified first in the definition file.
"rbc" is recommended as an extension of the definition file.

=== Format

The format of the definition file is as follows.
<tab> is one or more tab characters.

==== Comment

The line begins with "#" is a comment.

==== Character specification

The line begins with "kcode" is the specification of the character set.

  kcode<tab><character set>

You can have a choice from "none", "euc", "sjis" or "utf8" as the character set.

==== Script Definition

The line begins with "script" is a specification of a script file.

  script<tab><internal name><tab><file name>

The internal name is a file name when it was stored in the archive file. That is
used by require, back tracing and other.
<file name> is a file name of script which is stored actually.
This file name should be specified by a relative path from the definition file,
or an absolute path.

==== Extension library definition

The line begins with "library" is a specification of an extension-library.

  library<tab><internal name><tab><file name>

<internal> and <file name> are same as the script definition.

=== Example of description

  # example
  kcode		sjis
  script	foo.rb		bin/foo.rb
  library	Win32API.so	lib/Win32API.so

== Sample

Four samples are in the example directory.

: sample1
    This is the sample which displays a message box using Win32API.

: sample2
    This is the sample which occurs an exception and displays an
    exception dialog.

: sample3
    This is the sample which displays a window using VisualuRuby.

: sample4
    This is the sample which gets strings from the standard input,
    and puts these with line numbers.

To convert sample1 into an executable file, do as followings.

  $ cd example
  $ exerb.rb -c gui sample1.rbc

You can convert sample2 and sample3 in same method.
Use the cui core for sample4. (Because it use standard input/output)

=== The libraries which are used in samples

VisualuRuby(under vr/, and swin.so) and Win32API(Win32API.so) are used in
sample programs.

VisualuRuby is a Win32 GUI library that is provided by NISHIKAWA Yasuhiro.
You can get the information about VisualuRuby from
((<URL:http://www.osk.3web.ne.jp/~nyasu/software/vrproject.html>)).
Thanks for the great library.

== The core

There are two kinds of the cores, the GUI version and the CUI version.
The name "ruby167g.rbx" is for the GUI version, and the name "ruby167c.rbx" for
the CUI version.
The deference between the GUI version and the CUI version is as follows.

* In the GUI version, standard input/output can't be used, the CUI version can
  use that.
* In the GUI version, the dialog is popped up when an exception is raised, in
  the CUI version, the message is written to a console.

== How to get

You can get the latest information and version of Exerb at the following URL.

* ((<URL:http://exerb.sourceforge.jp/>))
* ((<URL:http://sourceforge.jp/projects/exerb/>))

And you can get the information and source code of Ruby at the following URL.

* ((<URL:http://www.ruby-lang.org/>))

== Checking environment

We checked out that the executable file created by Exerb can run on following
environments.

* Microsoft WindowsXP
* Microsoft Windows2000
* Microsoft WindowsMe
* Microsoft Windows98 SecondEdition
* Microsoft Windows98
* Microsoft Windows95

== License

You can redistribute it and/or modify it under the terms of the	LGPL.

== Copyright

* The Ruby part of Exerb is copyrighted by Yukihiro Matsumoto and the people
  who is concerned in the development of it.
* The other parts is copyrighted by Yuya Kato.

== Exemption from responsibility

THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

== Acknowledgment

We would like to thank Yukihiro Matsumoto and the other people who is concerned
in the development of the Great language Ruby.
Thanks for the great language!

== Author

Yuya Kato <yuya@katoden.co.jp>

I'll be happy if you send me your advices, impressions, demands or bug reports.

== And

Good Ruby life. :-)

=end
