/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SheetData {
    private String sheetName = null;
    private Map<String, List<Object>> tagValueMap = new HashMap<String, List<Object>>();
    private List<String> keyList = new ArrayList<String>();

    public SheetData(String sheetName) {
        this.sheetName = sheetName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void put(String tagName, Object result) {
        if (this.keyList.contains(tagName)) {
            this.keyList.remove(tagName);
        }
        this.keyList.add(tagName);
        List<Object> values = this.tagValueMap.get(tagName);
        if (values == null) {
            values = new ArrayList<Object>();
            this.tagValueMap.put(tagName, values);
        }
        values.add(result);
    }

    public Object get(String tagName) {
        List<Object> results = this.tagValueMap.get(tagName);
        if (results != null && !results.isEmpty()) {
            return results.get(results.size() - 1);
        }
        return null;
    }

    public List<Object> getList(String tagName) {
        return this.tagValueMap.get(tagName);
    }

    public Set<String> getTagNames() {
        return this.tagValueMap.keySet();
    }

    public boolean containsTag(String tagName) {
        return this.tagValueMap.containsKey(tagName);
    }

    public List<String> getKeyList() {
        return this.keyList;
    }

    public Object remove(Object key) {
        this.keyList.remove(key);
        return this.tagValueMap.remove(key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("=====================" + this.sheetName + "=====================");
        List<String> keys = this.getKeyList();
        for (String key : keys) {
            builder.append("\n");
            builder.append("\t");
            builder.append(key);
            builder.append("\t");
            builder.append(this.get(key));
        }
        return builder.toString();
    }
}

