/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.tag;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.reports.model.ParamInfo;
import org.bbreak.excella.reports.model.ParsedReportInfo;
import org.bbreak.excella.reports.processor.ReportsParserInfo;
import org.bbreak.excella.reports.tag.ReportsTagParser;
import org.bbreak.excella.reports.util.ReportsUtil;

public class SumParamParser
extends ReportsTagParser<Object> {
    public static final String DEFAULT_TAG = "$SUM";
    public static final String PARAM_VALUE = "";

    public SumParamParser() {
        super(DEFAULT_TAG);
    }

    public SumParamParser(String tag) {
        super(tag);
    }

    @Override
    public ParsedReportInfo parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
        ReportsParserInfo reportsParserInfo = (ReportsParserInfo)data;
        ParamInfo paramInfo = reportsParserInfo.getParamInfo();
        BigDecimal paramValue = null;
        if (paramInfo != null) {
            String replaceParam = (String)paramDef.get(PARAM_VALUE);
            paramValue = ReportsUtil.getSumValue(paramInfo, replaceParam, reportsParserInfo.getReportParsers());
            PoiUtil.setCellValue((Cell)tagCell, (Object)paramValue);
        }
        ParsedReportInfo parsedReportInfo = new ParsedReportInfo();
        parsedReportInfo.setParsedObject(paramValue);
        parsedReportInfo.setRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setColumnIndex(tagCell.getColumnIndex());
        parsedReportInfo.setDefaultRowIndex(tagCell.getRowIndex());
        parsedReportInfo.setDefaultColumnIndex(tagCell.getColumnIndex());
        return parsedReportInfo;
    }

    @Override
    public boolean useControlRow() {
        return false;
    }
}

