/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.exporter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.reports.exporter.ReportBookExporter;
import org.bbreak.excella.reports.model.ConvertConfiguration;

public class XLSExporter
extends ReportBookExporter {
    private static Log log = LogFactory.getLog(XLSExporter.class);
    public static final String FORMAT_TYPE = "XLS";
    public static final String EXTENTION = ".xls";

    @Override
    public void output(Workbook book, BookData bookdata, ConvertConfiguration configuration) throws ExportException {
        if (!(book instanceof HSSFWorkbook)) {
            throw new IllegalArgumentException("Workbook is not HSSFWorkbook.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\u51e6\u7406\u7d50\u679c\u3092" + this.getFilePath() + "\u306b\u51fa\u529b\u3057\u307e\u3059\u3002"));
        }
        try {
            PoiUtil.writeBook((Workbook)book, (String)this.getFilePath());
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
    }

    @Override
    public String getFormatType() {
        return FORMAT_TYPE;
    }

    @Override
    public String getExtention() {
        return EXTENTION;
    }
}

