/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.reports.exporter;

import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.Workbook;
import org.bbreak.excella.core.BookData;
import org.bbreak.excella.core.exception.ExportException;
import org.bbreak.excella.core.exporter.book.BookExporter;
import org.bbreak.excella.reports.model.ConvertConfiguration;

public abstract class ReportBookExporter
implements BookExporter {
    private ConvertConfiguration configuration = null;
    private String filePath = null;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void export(Workbook book, BookData bookdata) throws ExportException {
        TreeSet deleteSheetIndexs = new TreeSet(Collections.reverseOrder());
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            String sheetName = book.getSheetName(i);
            if (!sheetName.startsWith("-@%delete%_tmpSheet")) continue;
            deleteSheetIndexs.add(i);
        }
        Iterator i$ = deleteSheetIndexs.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            book.removeSheetAt(index);
        }
        if (this.configuration != null) {
            this.output(book, bookdata, this.configuration);
        }
    }

    public abstract void output(Workbook var1, BookData var2, ConvertConfiguration var3) throws ExportException;

    public abstract String getFormatType();

    public abstract String getExtention();

    public void setConfiguration(ConvertConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setup() {
    }

    public void tearDown() {
    }
}

