<?php
// vim: foldmethod=marker
/**
 *  Ethna_View_List.php
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_View_List.php 298 2006-07-19 05:22:39Z fujimoto $
 */

// {{{ Ethna_View_List
/**
 *  ꥹȥӥ塼쥯饹μ
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_View_List extends Ethna_ViewClass
{
    /**#@+
     *  @access private
     */

    /** @var    int     ɽϥեå */
    var $offset = 0;

    /** @var    int     ɽ */
    var $count = 25;

    /** @var    array   оݹܰ */
    var $search_list = array();

    /** @var    string  ޥ͡㥯饹̾ */
    var $manager_name = null;

    /** @var    string  ɽоݥ饹̾ */
    var $class_name = null;

    /**#@-*/

    /**
     *  
     *
     *  @access public
     */
    function preforward()
    {
        // ɽեå/
        $this->offset = $this->af->get('offset');
        if ($this->offset == "") {
            $this->offset = 0;
        }
        if (intval($this->af->get('count')) > 0) {
            $this->count = intval($this->af->get('count'));
        }

        // 
        $filter = array();
        $sort = array();
        foreach ($this->search_list as $key) {
            if ($this->af->get("s_$key") != "") {
                $filter[$key] = $this->af->get("s_$key");
            }
            if ($this->af->get("sort") == $key) {
                $order = $this->af->get("order") == "desc" ? OBJECT_SORT_DESC : OBJECT_SORT_ASC;
                $sort = array(
                    $key => $order,
                );
            }
        }

        // ɽܰ
        $manager_name = $this->manager_name;
        for ($i = 0; $i < 2; $i++) {
            list($total, $obj_list) = $this->$manager_name->getObjectList($this->class_name, $filter, $sort, $this->offset, $this->count);
            if (count($obj_list) == 0 && $this->offset >= $total) {
                $this->offset = 0;
                continue;
            }
            break;
        }

        $r = array();
        foreach ($obj_list as $obj) {
            $value = $obj->getNameObject();
            $value = $this->_fixNameObject($value, $obj);
            $r[] = $value;
        }
        $list_name = sprintf("%s_list", strtolower(preg_replace('/(.)([A-Z])/', '\\1_\\2', $this->class_name)));
        $this->af->setApp($list_name, $r);

        // ʥӥ
        $this->af->setApp('nav', $this->_getNavigation($total, $obj_list));
        $this->af->setAppNE('query', $this->_getQueryParameter());

        // ץ
        $this->_setQueryOption();
    }

    /**
     *  ɽܤ
     *
     *  @access protected
     */
    function _fixNameObject($value, $obj)
    {
        return $value;
    }
    
    /**
     *  ʥӥ
     *
     *  @access private
     *  @param  int     $total      
     *  @param  array   $list       
     *  @return array   ʥӥǼ
     */
    function _getNavigation($total, &$list)
    {
        $nav = array();
        $nav['offset'] = $this->offset;
        $nav['from'] = $this->offset + 1;
        if ($total == 0) {
            $nav['from'] = 0;
        }
        $nav['to'] = $this->offset + count($list);
        $nav['total'] = $total;
        if ($this->offset > 0) {
            $prev_offset = $this->offset - $this->count;
            if ($prev_offset < 0) {
                $prev_offset = 0;
            }
            $nav['prev_offset'] = $prev_offset;
        }
        if ($this->offset + $this->count < $total) {
            $next_offset = $this->offset + count($list);
            $nav['next_offset'] = $next_offset;
        }
        $nav['direct_link_list'] = Ethna_Util::getDirectLinkList($total, $this->offset, $this->count);

        return $nav;
    }

    /**
     *  ܤ
     *
     *  @access protected
     */
    function _setQueryOption()
    {
    }

    /**
     *  ƤǼGET
     *
     *  @access private
     *  @param  array   $search_list    оݰ
     *  @return string  ƤǼGET
     */
    function _getQueryParameter()
    {
        $query = "";

        foreach ($this->search_list as $key) {
            $value = $this->af->get("s_$key");
            if (is_array($value)) {
                foreach ($value as $v) {
                    $query .= "&s_$key" . "[]=" . urlencode($v);
                }
            } else {
                $query .= "&s_$key=" . urlencode($value);
            }
        }

        return $query;
    }
}
// }}}
?>
