<?php
// vim: foldmethod=marker tabstop=4 shiftwidth=4 autoindent
/**
 *  Ethna_Plugin_Cachemanager_Memcache.php
 *
 *  - Point CutȻפä
 *  - å奭ˤ250ʸޤǤѤǤʤΤդƲ
 *
 *  @todo   ͡ॹڡ/å奭ĹΥ顼ϥɥ
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin_Cachemanager_Memcache.php 483 2007-10-30 14:56:00Z cocoitiban $
 */

/**
 *  åޥ͡㥯饹(memcache)
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin_Cachemanager_Memcache extends Ethna_Plugin_Cachemanager
{
    /**#@+  @access private */

    /** @var    object  MemCache    MemCache֥ */
    var $memcache = null;

    /** @var bool ̥ե饰 */
    var $compress = true;

    /**#@-*/

    /**
     *  Ethna_Plugin_Cachemanager_Memcache饹Υ󥹥ȥ饯
     *
     *  @access public
     */
    function Ethna_Plugin_Cachemanager_Memcache(&$controller)
    {
        parent::Ethna_Plugin_Cachemanager($controller);
        $this->memcache_pool = array();
    }

    /**
     *  memcacheå奪֥Ȥ
     *
     *  @access protected
     */
    function _getMemcache($cache_key, $namespace = null)
    {
        $retry = $this->config->get('memcache_retry');
        if ($retry == "") {
            $retry = 3;
        }
        $timeout = $this->config->get('memcache_timeout');
        if ($timeout == "") {
            $timeout = 3;
        }
        $r = false;

        list($host, $port) = $this->_getMemcacheInfo($cache_key, $namespace);
        if (isset($this->memcache_pool["$host:$port"])) {
            // activate
            $this->memcache = $this->memcache_pool["$host:$port"];
            return $this->memcache;
        }
        $this->memcache_pool["$host:$port"] =& new MemCache();

        while ($retry > 0) {
            if ($this->config->get('memcache_use_connect')) {
                $r = $this->memcache_pool["$host:$port"]->connect($host, $port, $timeout);
            } else {
                $r = $this->memcache_pool["$host:$port"]->pconnect($host, $port, $timeout);
            }
            if ($r) {
                break;
            }
            sleep(1);
            $retry--;
        }
        if ($r == false) {
            trigger_error("memcache: connection failed");
            $this->memcache_pool["$host:$port"] = null;
        }

        $this->memcache = $this->memcache_pool["$host:$port"];
        return $this->memcache;
    }

    /**
     *  memcache³
     *
     *  @access protected
     *  @todo   $cache_key$indexˡѹǤ褦ˤ
     */
    function _getMemcacheInfo($cache_key, $namespace)
    {
        $namespace = is_null($namespace) ? $this->namespace : $namespace;

        $memcache_info = $this->config->get('memcache');
        $default_memcache_host = $this->config->get('memcache_host');
        if ($default_memcache_host == "") {
            $default_memcache_host = "localhost";
        }
        $default_memcache_port = $this->config->get('memcache_port');
        if ($default_memcache_port == "") {
            $default_memcache_port = 11211;
        }
        if ($memcache_info == null || isset($memcache_info[$namespace]) == false) {
            return array($default_memcache_host, $default_memcache_port);
        }

        // namespace/cache_key³
        $n = count($memcache_info[$namespace]);

        $index = $cache_key % $n;
        return array(
            isset($memcache_info[$namespace][$index]['memcache_host']) ?
                $memcache_info[$namespace][$index]['memcache_host'] :
                'localhost',
            isset($memcache_info[$namespace][$index]['memcache_port']) ?
                $memcache_info[$namespace][$index]['memcache_port'] :
                11211,
        );

        // for safe
        return array($default_memcache_host, $default_memcache_port);
    }

    /**
     *  åꤵ줿ͤ
     *
     *  åͤꤵƤϥå
     *  ͤȤʤ롣å̵ͤlifetime
     *  ᤮Ƥ硢顼ȯPEAR_Error
     *  ֥ȤͤȤʤ롣
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  int     $lifetime   åͭ
     *  @param  string  $namespace  å͡ॹڡ
     *  @return array   å
     */
    function get($key, $lifetime = null, $namespace = null)
    {
        $this->_getMemcache($key, $namespace);
        if ($this->memcache == null) {
            return Ethna::raiseError('memcache server not available', E_CACHE_NO_VALUE);
        }

        $namespace = is_null($namespace) ? $this->namespace : $namespace;

        $cache_key = $this->_getCacheKey($namespace, $key);
        if ($cache_key == null) {
            return Ethna::raiseError('invalid cache key (too long?)', E_CACHE_NO_VALUE);
        }

        $value = $this->memcache->get($cache_key);
        if ($value == null) {
            return Ethna::raiseError('no such cache', E_CACHE_NO_VALUE);
        }
        $time = $value['time'];
        $data = $value['data'];

        // 饤եå
        if (is_null($lifetime) == false) {
            if (($time+$lifetime) < time()) {
                return Ethna::raiseError('lifetime expired', E_CACHE_EXPIRED);
            }
        }

        return $data;
    }

    /**
     *  åκǽ
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  string  $namespace  å͡ॹڡ
     *  @return int     ǽ(unixtime)
     */
    function getLastModified($key, $namespace = null)
    {
        $this->_getMemcache($key, $namespace);
        if ($this->memcache == null) {
            return Ethna::raiseError('memcache server not available', E_CACHE_NO_VALUE);
        }

        $namespace = is_null($namespace) ? $this->namespace : $namespace;

        $cache_key = $this->_getCacheKey($namespace, $key);
        if ($cache_key == null) {
            return Ethna::raiseError('invalid cache key (too long?)', E_CACHE_NO_VALUE);
        }

        $value = $this->memcache->get($cache_key);

        return $value['time'];
    }

    /**
     *  ͤå夵Ƥ뤫ɤ
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  int     $lifetime   åͭ
     *  @param  string  $namespace  å͡ॹڡ
     */
    function isCached($key, $lifetime = null, $namespace = null)
    {
        $r = $this->get($key, $lifetime, $namespace);

        return PEAR::isError($r) ? false: true;
    }

    /**
     *  åͤꤹ
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  mixed   $value      å
     *  @param  int     $timestamp  åǽ(unixtime)
     *  @param  string  $namespace  å͡ॹڡ
     */
    function set($key, $value, $timestamp = null, $namespace = null)
    {
        $this->_getMemcache($key, $namespace);
        if ($this->memcache == null) {
            return Ethna::raiseError('memcache server not available', E_CACHE_NO_VALUE);
        }

        $namespace = is_null($namespace) ? $this->namespace : $namespace;

        $cache_key = $this->_getCacheKey($namespace, $key);
        if ($cache_key == null) {
            return Ethna::raiseError('invalid cache key (too long?)', E_CACHE_NO_VALUE);
        }

        $time = $timestamp ? $timestamp : time();
        $this->memcache->set($cache_key, array('time' => $time, 'data' => $value), $this->compress ? MEMCACHE_COMPRESSED : null);
    }

    /**
     *  åͤ
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  string  $namespace  å͡ॹڡ
     */
    function clear($key, $namespace = null)
    {
        $this->_getMemcache($key, $namespace);
        if ($this->memcache == null) {
            return Ethna::raiseError('memcache server not available', E_CACHE_NO_VALUE);
        }

        $namespace = is_null($namespace) ? $this->namespace : $namespace;

        $cache_key = $this->_getCacheKey($namespace, $key);
        if ($cache_key == null) {
            return Ethna::raiseError('invalid cache key (too long?)', E_CACHE_NO_VALUE);
        }

        $this->memcache->delete($cache_key, -1);
    }

    /**
     *  åǡå
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  int     $timeout    åॢ
     *  @param  string  $namespace  å͡ॹڡ
     *  @return bool    true: false:
     */
    function lock($key, $timeout = 5, $namespace = null)
    {
        $this->_getMemcache($key, $namespace);
        if ($this->memcache == null) {
            return Ethna::raiseError('memcache server not available', E_CACHE_LOCK_ERROR);
        }

        // åѥåǡѤ
        $namespace = is_null($namespace) ? $this->namespace : $namespace;
        $cache_key = "lock::" . $this->_getCacheKey($namespace, $key);
        $lock_lifetime = 30;

        do {
            $r = $this->memcache->add($cache_key, true, false, $lock_lifetime);
            if ($r != false) {
                break;
            }
            sleep(1);
            $timeout--;
        } while ($timeout > 0);

        if ($r == false) {
            return Ethna::raiseError('lock timeout', E_CACHE_LOCK_TIMEOUT);
        }

        return true;
    }

    /**
     *  åǡΥå
     *
     *  @access public
     *  @param  string  $key        å奭
     *  @param  string  $namespace  å͡ॹڡ
     *  @return bool    true: false:
     */
    function unlock($key, $namespace = null)
    {
        $this->_getMemcache($key, $namespace);
        if ($this->memcache == null) {
            return Ethna::raiseError('memcache server not available', E_CACHE_LOCK_ERROR);
        }

        $namespace = is_null($namespace) ? $this->namespace : $namespace;
        $cache_key = "lock::" . $this->_getCacheKey($namespace, $key);

        $this->memcache->delete($cache_key, -1);
    }

    /**
     *  ͡ॹڡ饭å奭
     *
     *  @access private
     */
    function _getCacheKey($namespace, $key)
    {
        // ˽...
        $key = str_replace(":", "_", $key);
        $cache_key = $namespace . "::" . $key;
        if (strlen($cache_key) > 250) {
            return null;
        }
        return $cache_key;
    }

    /**
     * ̥ե饰ΩƤ
     *
     * MySQLʤɤĤλҥ饹ͭ
     * 
     * @access public
     * @param bool $flag ե饰
     */
    function setCompress($flag) {
        $this->compress = $flag;
    }
}
?>
