<?php
// vim: foldmethod=marker
/**
 *  Ethna_Backend.php
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Backend.php 465 2007-07-04 13:33:09Z ichii386 $
 */

// {{{ Ethna_Backend
/**
 *  Хåɽ饹
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Backend
{
    /**#@+
     *  @access     private
     */

    /** @var    object  Ethna_Controller    controller֥ */
    var $controller;

    /** @var    object  Ethna_Controller    controller֥($controllerξά) */
    var $ctl;

    /** @var    object  Ethna_ClassFactory  饹եȥꥪ֥ */
    var $class_factory;

    /** @var    object  Ethna_Config        ꥪ֥ */
    var $config;

    /** @var    object  Ethna_I18N          i18n֥ */
    var $i18n;

    /** @var    object  Ethna_ActionError   󥨥顼֥ */
    var $action_error;

    /** @var    object  Ethna_ActionError   󥨥顼֥($action_errorξά) */
    var $ae;

    /** @var    object  Ethna_ActionForm    ե४֥ */
    var $action_form;

    /** @var    object  Ethna_ActionForm    ե४֥($action_formξά) */
    var $af;

    /** @var    object  Ethna_ActionClass   󥯥饹֥ */
    var $action_class;

    /** @var    object  Ethna_ActionClass   󥯥饹֥($action_classξά) */
    var $ac;

    /** @var    object  Ethna_Session       å󥪥֥ */
    var $session;

    /** @var    object  Ethna_Plugin        ץ饰󥪥֥ */
    var $plugin;

    /** @var    array   Ethna_DB֥ȤǼ */
    var $db_list;

    /** @var    object  Ethna_Logger        ֥ */
    var $logger;

    /**#@-*/


    /**
     *  Ethna_Backend饹Υ󥹥ȥ饯
     *
     *  @access public
     *  @param  object  Ethna_Controller    &$controller    ȥ饪֥
     */
    function Ethna_Backend(&$controller)
    {
        // ֥Ȥ
        $this->controller =& $controller;
        $this->ctl =& $this->controller;

        $this->class_factory =& $controller->getClassFactory();

        $this->config =& $controller->getConfig();
        $this->i18n =& $controller->getI18N();

        $this->action_error =& $controller->getActionError();
        $this->ae =& $this->action_error;
        $this->action_form =& $controller->getActionForm();
        $this->af =& $this->action_form;
        $this->action_class = null;
        $this->ac =& $this->action_class;

        $this->session =& $this->controller->getSession();
        $this->plugin =& $this->controller->getPlugin();
        $this->db_list = array();
        $this->logger =& $this->controller->getLogger();
    }

    /**
     *  controller֥ȤؤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_Controller    controller֥
     */
    function &getController()
    {
        return $this->controller;
    }

    /**
     *  ꥪ֥ȤؤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_Config        ꥪ֥
     */
    function &getConfig()
    {
        return $this->config;
    }

    /**
     *  ץꥱID֤
     *
     *  @access public
     *  @return string  ץꥱID
     */
    function getAppId()
    {
        return $this->controller->getAppId();
    }

    /**
     *  I18N֥ȤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_I18N  i18n֥
     */
    function &getI18N()
    {
        return $this->i18n;
    }

    /**
     *  󥨥顼֥ȤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_ActionError   󥨥顼֥
     */
    function &getActionError()
    {
        return $this->action_error;
    }

    /**
     *  ե४֥ȤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_ActionForm    ե४֥
     */
    function &getActionForm()
    {
        return $this->action_form;
    }

    /**
     *  ե४֥ȤΥ(W)
     *
     *  @access public
     */
    function setActionForm(&$action_form)
    {
        $this->action_form =& $action_form;
        $this->af =& $action_form;
    }

    /**
     *  ¹Υ󥯥饹֥ȤΥ(R)
     *
     *  @access public
     *  @return mixed   Ethna_ActionClass:󥯥饹 null:󥯥饹̤
     */
    function &getActionClass()
    {
        return $this->action_class;
    }

    /**
     *  ¹Υ󥯥饹֥ȤΥ(W)
     *
     *  @access public
     */
    function setActionClass(&$action_class)
    {
        $this->action_class =& $action_class;
        $this->ac =& $action_class;
    }

    /**
     *  ֥ȤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_Logger    ֥
     */
    function &getLogger()
    {
        return $this->logger;
    }

    /**
     *  å󥪥֥ȤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_Session   å󥪥֥
     */
    function &getSession()
    {
        return $this->session;
    }

    /**
     *  ץ饰󥪥֥ȤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_Plugin    ץ饰󥪥֥
     */
    function &getPlugin()
    {
        return $this->plugin;
    }

    /**
     *  ޥ͡㥪֥ȤؤΥ(R)
     *
     *  @access public
     *  @return object  Ethna_AppManager    ޥ͡㥪֥
     */
    function &getManager($type, $weak = false)
    {
        $_ret_object =& $this->class_factory->getManager($type, $weak);
        return $_ret_object;
    }

    /**
     *  ֥ȤؤΥ(R)
     *
     *  @access public
     *  @return mixed   $keyб륪֥(or null)
     */
    function &getObject($key)
    {
        $arg_list = func_get_args();
        array_shift($arg_list);
        $_ret_object =& $this->class_factory->getObject($key, $arg_list);
        return $_ret_object;
    }

    /**
     *  ץꥱΥ١ǥ쥯ȥ
     *
     *  @access public
     *  @return string  ١ǥ쥯ȥΥѥ̾
     */
    function getBasedir()
    {
        return $this->controller->getBasedir();
    }

    /**
     *  ץꥱΥƥץ졼ȥǥ쥯ȥ
     *
     *  @access public
     *  @return string  ƥץ졼ȥǥ쥯ȥΥѥ̾
     */
    function getTemplatedir()
    {
        return $this->controller->getTemplatedir();
    }

    /**
     *  ץꥱǥ쥯ȥ
     *
     *  @access public
     *  @return string  ǥ쥯ȥΥѥ̾
     */
    function getEtcdir()
    {
        return $this->controller->getDirectory('etc');
    }

    /**
     *  ץꥱΥƥݥǥ쥯ȥ
     *
     *  @access public
     *  @return string  ƥݥǥ쥯ȥΥѥ̾
     */
    function getTmpdir()
    {
        return $this->controller->getDirectory('tmp');
    }

    /**
     *  ץꥱΥƥץ졼ȥեĥҤ
     *
     *  @access public
     *  @return string  ƥץ졼ȥեγĥ
     */
    function getTemplateext()
    {
        return $this->controller->getExt('tpl');
    }

    /**
     *  Ϥ
     *
     *  @access public
     *  @param  int     $level      ٥(LOG_DEBUG, LOG_NOTICE...)
     *  @param  string  $message    å(printf)
     */
    function log($level, $message)
    {
        $args = func_get_args();
        if (count($args) > 2) {
            array_splice($args, 0, 2);
            $message = vsprintf($message, $args);
        }
        $this->logger->log($level, $message);
    }

    /**
     *  Хåɽ¹Ԥ
     *
     *  @access public
     *  @param  string  $action_name    ¹Ԥ륢̾
     *  @return mixed   (string):Forward̾(nullʤforwardʤ) Ethna_Error:顼
     */
    function perform($action_name)
    {
        $forward_name = null;

        $action_class_name = $this->controller->getActionClassName($action_name);
        $this->action_class =& new $action_class_name($this);
        $this->ac =& $this->action_class;

        // μ¹
        $forward_name = $this->ac->authenticate();
        if ($forward_name === false) {
            return null;
        } else if ($forward_name !== null) {
            return $forward_name;
        }

        $forward_name = $this->ac->prepare();
        if ($forward_name === false) {
            return null;
        } else if ($forward_name !== null) {
            return $forward_name;
        }

        $forward_name = $this->ac->perform();

        return $forward_name;
    }

    /**
     *  DB֥Ȥ֤
     *
     *  @access public
     *  @param  string  $db_key DB
     *  @return mixed   Ethna_DB:DB֥ null:DSNʤ Ethna_Error:顼
     *  @todo   newʤclass factoryѤ
     */
    function &getDB($db_key = "")
    {
        $null = null;
        $db_varname =& $this->_getDBVarname($db_key);

        if (Ethna::isError($db_varname)) {
            return $db_varname;
        }

        if (isset($this->db_list[$db_varname]) && $this->db_list[$db_varname] != null) {
            return $this->db_list[$db_varname];
        }

        $dsn = $this->controller->getDSN($db_key);

        if ($dsn == "") {
            // DB³
            return $null;
        }

        $dsn_persistent = $this->controller->getDSN_persistent($db_key);

        $class_factory =& $this->controller->getClassFactory();
        $db_class_name = $class_factory->getObjectName('db');
        
        // BC: Ethna_DB -> Ethna_DB_PEAR
        if ($db_class_name == 'Ethna_DB') {
            $db_class_name = 'Ethna_DB_PEAR';
        }
        if (class_exists($db_class_name) === false) {
            $class_factory->_include($db_class_name);
        }

        $this->db_list[$db_varname] =& new $db_class_name($this->controller, $dsn, $dsn_persistent);
        $r = $this->db_list[$db_varname]->connect();
        if (Ethna::isError($r)) {
            $this->db_list[$db_varname] = null;
            return $r;
        }

        register_shutdown_function(array(&$this, 'shutdownDB'));

        return $this->db_list[$db_varname];
    }

    /**
     *  DB֥()
     *
     *  @access public
     *  @return mixed   array:Ethna_DB֥Ȥΰ Ethan_Error:(줫İʾ³)顼
     */
    function getDBList()
    {
        $r = array();
        $db_define_list = $this->controller->getDBType();
        foreach ($db_define_list as $db_key => $db_type) {
            $db =& $this->getDB($db_key);
            if (Ethna::isError($db)) {
                return $r;
            }
            $elt = array();
            $elt['db'] =& $db;
            $elt['key'] = $db_key;
            $elt['type'] = $db_type;
            $elt['varname'] = "db";
            if ($db_key != "") {
                $elt['varname'] = sprintf("db_%s", strtolower($db_key));
            }
            $r[] = $elt;
        }
        return $r;
    }

    /**
     *  DBͥǤ
     *
     *  @access public
     */
    function shutdownDB()
    {
        foreach (array_keys($this->db_list) as $key) {
            if ($this->db_list[$key] != null && $this->db_list[$key]->isValid()) {
                $this->db_list[$key]->disconnect();
                unset($this->db_list[$key]);
            }
        }
    }

    /**
     *  ꤵ줿DBб(DB֥ȤǼ뤿)ѿ̾
     *
     *  ľ⤦פʤΤǤߴݻΤ˰ĤƤ֤Ǥ
     *  (Ethna_AppManager饹ʤɤǡ$this->dbȤƤս꤬ʤ餺
     *  Τ)
     *
     *  @access private
     *  @param  string  $db_key DB
     *  @return mixed   string:ѿ̾ Ethna_Error:DB
     */
    function &_getDBVarname($db_key = "")
    {
        $r = $this->controller->getDBType($db_key);
        if (is_null($r)) {
            return Ethna::raiseError("̤DB[%s]", E_DB_INVALIDTYPE, $db_key);
        }

        if ($db_key == "") {
            $db_varname = "";
        } else {
            $db_varname = sprintf("%s", strtolower($db_key));
        }

        return $db_varname;
    }
}
// }}}
?>
