<?php
// vim: foldmethod=marker
/**
 *  Ethna_Plugin_Logwriter.php
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: Ethna_Plugin_Logwriter.php,v 1.2 2006/07/19 05:22:38 fujimoto Exp $
 */

// {{{ Ethna_Plugin_Logwriter
/**
 *  ϴ쥯饹
 *
 *  @author     Masaki Fujimoto <fujimoto@php.net>
 *  @access     public
 *  @package    Ethna
 */
class Ethna_Plugin_Logwriter
{
    /**#@+
     *  @access private
     */

    /** @var    string  ǥƥƥʸ */
    var $ident;

    /** @var    int     եƥ */
    var $facility;

    /** @var    int     ץ */
    var $option;

    /** @var    bool    Хåȥ졼ǽɤ */
    var $have_backtrace;

    /** @var    array   ٥̾ơ֥ */
    var $level_name_table = array(
        LOG_EMERG   => 'EMERG',
        LOG_ALERT   => 'ALERT',
        LOG_CRIT    => 'CRIT',
        LOG_ERR     => 'ERR',
        LOG_WARNING => 'WARNING',
        LOG_NOTICE  => 'NOTICE',
        LOG_INFO    => 'INFO',
        LOG_DEBUG   => 'DEBUG',
    );

    /**#@-*/

    /**
     *  Ethna_Plugin_Logwriter饹Υ󥹥ȥ饯
     *
     *  @access public
     *  @param  string  $log_ident      ǥƥƥʸ(ץ̾)
     *  @param  int     $log_facility   եƥ
     *  @param  string  $log_file       ե̾(LOG_FILEץ󤬻ꤵƤΤ)
     *  @param  int     $log_option     ץ(LOG_FILE,LOG_FUNCTION...)
     */
    function Ethna_Plugin_Logwriter()
    {
    }

    /**
     *  ץꤹ
     *
     *  @access public
     *  @param  int     $option     ץ(LOG_FILE,LOG_FUNCTION...)
     */
    function setOption($option)
    {
        $this->ident = $option['ident'];
        $this->facility = $option['facility'];
        $this->option = $option;
        $this->have_backtrace = function_exists('debug_backtrace');
    }

    /**
     *  Ϥ򳫻Ϥ
     *
     *  @access public
     */
    function begin()
    {
    }

    /**
     *  Ϥ
     *
     *  @access public
     *  @param  int     $level      ٥(LOG_DEBUG, LOG_NOTICE...)
     *  @param  string  $message    å(+)
     */
    function log($level, $message)
    {
    }

    /**
     *  Ϥλ
     *
     *  @access public
     */
    function end()
    {
    }

    /**
     *  ǥƥƥʸ
     *
     *  @access public
     *  @return string  ǥƥƥʸ
     */
    function getIdent()
    {
        return $this->ident;
    }

    /**
     *  ٥ɽʸѴ
     *
     *  @access private
     *  @param  int     $level  ٥(LOG_DEBUG,LOG_NOTICE...)
     *  @return string  ٥ɽʸ(LOG_DEBUG"DEBUG")
     */
    function _getLogLevelName($level)
    {
        if (isset($this->level_name_table[$level]) == false) {
            return null;
        }
        return $this->level_name_table[$level];
    }

    /**
     *  ϲսξ(ؿ̾/ե̾)
     *
     *  @access private
     *  @return array   ϲսξ
     */
    function _getBacktrace()
    {
        $skip_method_list = array(
            array('ethna', 'raise.*'),
            array(null, 'raiseerror'),
            array(null, 'handleerror'),
            array('ethna_logger', null),
            array('ethna_plugin_logwriter*', null),
            array('ethna_error', null),
            array('ethna_apperror', null),
            array('ethna_actionerror', null),
            array('ethna_backend', 'log'),
            array(null, 'ethna_error_handler'),
            array(null, 'trigger_error'),
        );

        if ($this->have_backtrace == false) {
            return null;
        }

        $bt = debug_backtrace();
        $i = 0;
        while ($i < count($bt)) {
            if (isset($bt[$i]['class']) == false) {
                $bt[$i]['class'] = null;
            }
            $skip = false;

            // ᥽åɥå׽
            foreach ($skip_method_list as $method) {
                $class = $function = true;
                if ($method[0] != null) {
                    $class = preg_match("/$method[0]/i", $bt[$i]['class']);
                }
                if ($method[1] != null) {
                    $function = preg_match("/$method[1]/i", $bt[$i]['function']);
                }
                if ($class && $function) {
                    $skip = true;
                    break;
                }
            }

            if ($skip) {
                $i++;
            } else {
                break;
            }
        }

        $c =& Ethna_Controller::getInstance();
        $basedir = $c->getBasedir();

        $function = sprintf("%s.%s", isset($bt[$i]['class']) ? $bt[$i]['class'] : 'global', $bt[$i]['function']);

        $file = $bt[$i]['file'];
        if (strncmp($file, $basedir, strlen($basedir)) == 0) {
            $file = substr($file, strlen($basedir));
        }
        if (strncmp($file, ETHNA_BASE, strlen(ETHNA_BASE)) == 0) {
            $file = preg_replace('#^/+#', '', substr($file, strlen(ETHNA_BASE)));
        }
        $line = $bt[$i]['line'];
        return array('function' => $function, 'pos' => sprintf('%s:%s', $file, $line));
    }
}
// }}}
?>
