<?php
/**
 *  ethna_run_test.php
 *
 *  Ethna Test Runner
 *
 *  @author     Kazuhiro Hosoi <hosoi@gree.co.jp>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *  @version    $Id: ethna_run_test.php,v 1.8 2006/11/28 04:52:53 ichii386 Exp $
 */

/** ץꥱ١ǥ쥯ȥ */
define('BASE', dirname(dirname(__FILE__)));

// include_path(ץꥱǥ쥯ȥɲ)
$app = BASE . "/app";
$lib = BASE . "/lib";

/** EthnaϢ饹Υ󥯥롼 */
require_once 'Ethna/Ethna.php';

/** SimpleTestΥ󥯥롼 */
require_once 'simpletest/unit_tester.php';
require_once 'simpletest/reporter.php';
require_once 'Ethna/test/TextDetailReporter.php';
require_once 'Ethna/test/Ethna_UnitTestBase.php';

/** ƥȥǥ쥯ȥ */
$test_dir = ETHNA_BASE . '/test';

$test = &new GroupTest('Ethna All tests');

// ƥȥΥեꥹȤ
require_once 'Console/Getopt.php';
$args = Console_Getopt::readPHPArgv();
list($args, $opts) = Console_Getopt::getopt2($args, '', array());
array_shift($opts);
if (count($opts) > 0) {
    $file_list = $opts;
} else {
    $file_list = getFileList($test_dir);
}

// ƥȥϿ
foreach ($file_list as $file) {
    $test->addTestFile($file);
}

// ̤򥳥ޥɥ饤˽
//$test->run(new TextReporter());
$test->run(new TextDetailReporter());

//{{{ getFileList
/**
 * getFileList
 *
 * @param string $dir_path
 */
function getFileList($dir_path)
{
    $file_list = array();

    $dir = opendir($dir_path);

    if ($dir == false) {
        return false;
    }

    while($file_path = readdir($dir)) {

        $full_path = $dir_path . '/'. $file_path;

        if (is_file($full_path)){

            // ƥȥΥեΤɤ߹
            if (preg_match('/^(Ethna_)(.*)(_Test.php)$/',$file_path,$matches)) {
                $file_list[] = $full_path;
            }

        // ֥ǥ쥯ȥ꤬ϡƵŪɤ߹ࡥ
        // "."ǻϤޤǥ쥯ȥɤ߹ޤʤ.
        } else if (is_dir($full_path) && !preg_match('/^\./',$file_path,$matches)) {

            $file_list = array_merge($file_list,getFileList($full_path));
        }
    }

    closedir($dir);
    return $file_list;
}
//}}}
?>
