<?php
// vim: foldmethod=marker tabstop=4 shiftwidth=4 autoindent
/**
 *	Ethna_CacheManager_Localfile.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *  @license    http://www.opensource.org/licenses/bsd-license.php The BSD License
 *  @package    Ethna
 *	@version    $Id: Ethna_CacheManager_Localfile.php,v 1.1 2006/06/05 14:53:12 fujimoto Exp $
 */

/**
 *	åޥ͡㥯饹(ե륭å)
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_CacheManager_Localfile extends Ethna_CacheManager
{
	/**#@+	@access	private	*/

	/**#@-*/

	/**
	 *	åꤵ줿ͤ
	 *
	 *	åͤꤵƤϥå
	 *	ͤȤʤ롣å̵ͤlifetime
	 *	᤮Ƥ硢顼ȯPEAR_Error
	 *	֥ȤͤȤʤ롣
	 *
	 *	@access	public
	 *	@param	string	$key		å奭
	 *	@param	int		$lifetime	åͭ
	 *	@param	string	$namespace	å͡ॹڡ
	 *	@return	array	å
	 */
	function get($key, $lifetime = null, $namespace = null)
	{
		$namespace = is_null($namespace) ? $this->namespace : $namespace;
		$cache_file = $this->_getCacheFile($namespace, $key);

		// 饤եå
		clearstatcache();
		$st = @stat($cache_file);
		if ($st == false) {
			return PEAR::raiseError('fopen failed', E_CACHE_NO_VALUE);
		}
		if (is_null($lifetime) == false) {
			if (($st[9]+$lifetime) < time()) {
				return PEAR::raiseError('fopen failed', E_CACHE_EXPIRED);
			}
		}

		$fp = fopen($cache_file, "r");
		if ($fp == false) {
			return PEAR::raiseError('fopen failed', E_CACHE_NO_VALUE);
		}
		// å
		$timeout = 3;
		while ($timeout > 0) {
			$r = flock($fp, LOCK_EX|LOCK_NB);
			if ($r) {
				break;
			}
			$timeout--;
			sleep(1);
		}
		if ($timeout <= 0) {
			fclose($fp);
			return PEAR::raiseError('fopen failed', E_CACHE_GENERAL);
		}

		$n = 0;
		while ($st[7] == 0) {
			clearstatcache();
			$st = @stat($cache_file);
			usleep(1000*1);
			$n++;
			if ($n > 5) {
				break;
			}
		}

		if ($st == false || $n > 5) {
			fclose($fp);
			return PEAR::raiseError('stat failed', E_CACHE_NO_VALUE);
		}
		$value = fread($fp, $st[7]);
		fclose($fp);

		return unserialize($value);
	}

	/**
	 *	åκǽ
	 *
	 *	@access	public
	 *	@param	string	$key		å奭
	 *	@param	string	$namespace	å͡ॹڡ
	 *	@return	int		ǽ(unixtime)
	 */
	function getLastModified($key, $namespace = null)
	{
		$namespace = is_null($namespace) ? $this->namespace : $namespace;
		$cache_file = $this->_getCacheFile($namespace, $key);

		clearstatcache();
		$st = @stat($cache_file);
		if ($st == false) {
			return PEAR::raiseError('fopen failed', E_CACHE_NO_VALUE);
		}
		return $st[9];
	}

	/**
	 *	ͤå夵Ƥ뤫ɤ
	 *
	 *	@access	public
	 *	@param	string	$key		å奭
	 *	@param	int		$lifetime	åͭ
	 *	@param	string	$namespace	å͡ॹڡ
	 */
	function isCached($key, $lifetime = null, $namespace = null)
	{
		$namespace = is_null($namespace) ? $this->namespace : $namespace;
		$cache_file = $this->_getCacheFile($namespace, $key);

		// 饤եå
		clearstatcache();
		$st = @stat($cache_file);
		if ($st == false) {
			return false;
		}
		if (is_null($lifetime) == false) {
			if (($st[9]+$lifetime) < time()) {
				return false;
			}
		}

		return true;
	}

	/**
	 *	åͤꤹ
	 *
	 *	@access	public
	 *	@param	string	$key		å奭
	 *	@param	mixed	$value		å
	 *	@param	int		$timestamp	åǽ(unixtime)
	 *	@param	string	$namespace	å͡ॹڡ
	 */
	function set($key, $value, $timestamp = null, $namespace = null)
	{
		$namespace = is_null($namespace) ? $this->namespace : $namespace;
		$dir = $this->_getCacheDir($namespace, $key);

		// åǥ쥯ȥå
		$dir_list = array();
		$tmp = $dir;
		while (is_dir($tmp) == false) {
			array_unshift($dir_list, $tmp);
			$tmp = dirname($tmp);
		}
		foreach ($dir_list as $tmp) {
			$r = @mkdir($tmp);
			if ($r == false && is_dir($tmp) == false) {
				$message = sprintf('mkdir(%s) failed', $tmp);
				trigger_error($message, E_USER_WARNING);
			}
			$this->_chmod($tmp, 0777);
		}

		$cache_file = $this->_getCacheFile($namespace, $key);
		$fp = fopen($cache_file, "a+");
		if ($fp == false) {
			return PEAR::raiseError('fopen failed', E_CACHE_GENERAL);
		}

		// å
		$timeout = 3;
		while ($timeout > 0) {
			$r = flock($fp, LOCK_EX|LOCK_NB);
			if ($r) {
				break;
			}
			$timeout--;
			sleep(1);
		}
		if ($timeout <= 0) {
			fclose($fp);
			return PEAR::raiseError('fopen failed', E_CACHE_GENERAL);
		}
		rewind($fp);
		ftruncate($fp, 0);
		fwrite($fp, serialize($value));
		fclose($fp);
		$this->_chmod($cache_file, 0666);

		if (is_null($timestamp)) {
			// this could suppress warning
			touch($cache_file);
		} else {
			touch($cache_file, $timestamp);
		}

		return 0;
	}

	/**
	 *	åͤ
	 *
	 *	@access	public
	 *	@param	string	$key		å奭
	 *	@param	string	$namespace	å͡ॹڡ
	 */
	function clear($key, $namespace = null)
	{
		$namespace = is_null($namespace) ? $this->namespace : $namespace;
		$cache_file = $this->_getCacheFile($namespace, $key);

		if (file_exists($cache_file)) {
			unlink($cache_file);
		}
	}

	/**
	 *	åоݥǥ쥯ȥ
	 *
	 *	@access	private
	 */
	function _getCacheDir($namespace, $key)
	{
		$len = strlen($key);
		// intentionally avoid using -2 or -4
		$dir1 = substr($key, $len-4, 2);
		if ($len-4 < 0 || strlen($dir1) < 2) {
			$dir1 = "__dir1";
		}
		$dir2 = substr($key, $len-2, 2);
		if ($len-2 < 0 || strlen($dir2) < 2) {
			$dir2 = "__dir2";
		}

        $map = $this->config->get('cachemanager_localfile');
		$tmp_key = $namespace . "::" . $key;
		// PHP¸:)
		$dir = "default";

        if (is_array($map)) {
            foreach ($map as $key => $value) {
                if (strncmp($key, $tmp_key, strlen($key)) == 0) {
                    $dir = $value;
                    break;
                }
            }
        }
		
        return sprintf("%s/cache/%s/cache_%s/%s/%s", $this->backend->getTmpdir(), $dir, $this->_escape($namespace), $this->_escape($dir1), $this->_escape($dir2));
	}

	/**
	 *	åե
	 *
	 *	@access	private
	 */
	function _getCacheFile($namespace, $key)
	{
		return sprintf("%s/%s", $this->_getCacheDir($namespace, $key), $this->_escape($key));
	}

	/**
	 *	ե륷ƥѤ˥פ
	 *
	 *	@access	private
	 */
	function _escape($string)
	{
		return preg_replace('/([^0-9A-Za-z_])/e', "sprintf('%%%02X', ord('\$1'))", $string);
	}

	/**
	 *	եΥѡߥåѹ
	 *
	 *	@access	private
	 */
	function _chmod($file, $mode)
	{
		$st = stat($file);
		if (($st[2] & 0777) == $mode) {
			return true;
		}
		return chmod($file, $mode);
	}
}
?>
