<?php
/**
 *	Ethna_SmartyPlugin.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_SmartyPlugin.php,v 1.4 2004/12/27 17:43:05 fujimoto Exp $
 */

/**
 *	smarty modifier:number_format()
 *
 *	number_format()ؿwrapper
 *
 *	sample:
 *	<code>
 *	{"12345"|number_format}
 *	</code>
 *	<code>
 *	12,345
 *	</code>
 *
 *	@param	string	$string	եޥåоʸ
 *	@return	string	եޥåȺѤʸ
 */
function smarty_modifier_number_format($string)
{
	if ($string === "" || $string == null) {
		return "";
	}
	return number_format($string);
}

/**
 *	smarty modifier:strftime()
 *
 *	strftime()ؿwrapper
 *
 *	sample:
 *	<code>
 *	{"2004/01/01 01:01:01"|strftime:"%Yǯ%m%d"}
 *	</code>
 *	<code>
 *	2004ǯ0101
 *	</code>
 *
 *	@param	string	$string	եޥåоʸ
 *	@param	string	$format	񼰻ʸ(strftime()ؿ)
 *	@return	string	եޥåȺѤʸ
 */
function smarty_modifier_strftime($string, $format)
{
	if ($string === "" || $string == null) {
		return "";
	}
	return strftime($format, strtotime($string));
}

/**
 *	smarty modifier:count()
 *
 *	count()ؿwrapper
 *
 *	sample:
 *	<code>
 *	$smarty->assign("array", array(1, 2, 3));
 *
 *	{$array|@count}
 *	</code>
 *	<code>
 *	3
 *	</code>
 *
 *	@param	array	$array	оݤȤʤ
 *	@return	int		ǿ
 */
function smarty_modifier_count($array)
{
	return count($array);
}

/**
 *	smarty modifier:join()
 *
 *	join()ؿwrapper
 *
 *	sample:
 *	<code>
 *	$smarty->assign("array", array(1, 2, 3));
 *
 *	{$array|@join:":"}
 *	</code>
 *	<code>
 *	1:2:3
 *	</code>
 *
 *	@param	array	$array	joinоݤ
 *	@param	string	$glue	Ϣʸ
 *	@return	string	Ϣʸ
 */
function smarty_modifier_join($array, $glue)
{
	if (is_array($array) == false) {
		return $array;
	}
	return implode($glue, $array);
}

/**
 *	smarty modifier:filter()
 *
 *	ꤵ줿ϢΤ$keyǻꤵ줿ǤΤߤ˺ƹ
 *
 *	sample:
 *	<code>
 *	$smarty->assign("array", array(
 *		array("foo" => 1, "bar" => 4),
 *		array("foo" => 2, "bar" => 5),
 *		array("foo" => 3, "bar" => 6),
 *	));
 *
 *	{$array|@filter:"foo"|@join:","}
 *	</code>
 *	<code>
 *	1,2,3
 *	</code>
 *	
 *	@param	array	$array	filterоݤȤʤ
 *	@param	string	$key	ȴФϢΥ
 *	@return	array	ƹ줿
 */
function smarty_modifier_filter($array, $key)
{
	if (is_array($array) == false) {
		return $array;
	}
	$tmp = array();
	foreach ($array as $v) {
		if (isset($v[$key]) == false) {
			continue;
		}
		$tmp[] = $v[$key];
	}
	return $tmp;
}

/**
 *	smarty modifier:unique()
 *
 *	unique()ؿwrapper
 *
 *	sample:
 *	<code>
 *	$smarty->assign("array1", array("a", "a", "b", "a", "b", "c"));
 *	$smarty->assign("array2", array(
 *		array("foo" => 1, "bar" => 4),
 *		array("foo" => 1, "bar" => 4),
 *		array("foo" => 1, "bar" => 4),
 *		array("foo" => 2, "bar" => 5),
 *		array("foo" => 3, "bar" => 6),
 *		array("foo" => 2, "bar" => 5),
 *	));
 *
 *	{$array1|@unique}
 *	{$array2|@unique:"foo"}
 *	</code>
 *	<code>
 *	abc
 *	123
 *	</code>
 *	
 *	@param	array	$array	оݤȤʤ
 *	@param	key		$key	оݤȤʤ륭(nullʤ)
 *	@return	array	ƹ줿
 */
function smarty_modifier_unique($array, $key = null)
{
	if (is_array($array) == false) {
		return $array;
	}
	if ($key != null) {
		$tmp = array();
		foreach ($array as $v) {
			if (isset($v[$key]) == false) {
				continue;
			}
			$tmp[$v[$key]] = $v;
		}
		return $tmp;
	} else {
		return array_unique($array);
	}
}

/**
 *	smarty modifier:ʸwordwrap(EUC-JPб)
 *
 *	sample:
 *	<code>
 *	{"aaaaaa"|wordrap_i18n:8}
 *	</code>
 *	<code>
 *	a
 *	aa
 *	aaa
 *	
 *	</code>
 *
 *	@param	string	$string	wordwrapʸ
 *	@param	string	$break	ʸ
 *	@param	int		$width	wordwrap(Ⱦ$widthʸwordwrap)
 *	@param	int		$indent	ǥ(Ⱦ$indentʸ)
 *	@return	string	wordwrap줿ʸ
 */
function smarty_modifier_wordwrap_i18n($string, $width, $break = "\n", $indent = 0)
{
	$r = "";
	$i = "$break" . str_repeat(" ", $indent);
	$tmp = $string;
	do {
		$s = mb_strimwidth($tmp, 0, $width, "", "EUC-JP");

		// EUC-JPΤб
		$n = strlen($s);
		if ($n >= $width && $tmp{$n} != "" && $tmp{$n} != " ") {
			while ((ord($s{$n-1}) & 0x80) == 0) {
				if ($s{$n-1} == " " || $n == 0) {
					break;
				}
				$n--;
			}
		}
		$s = substr($s, 0, $n);

		$r .= $s . $i;
		$tmp = substr($tmp, strlen($s));
	} while (strlen($s) > 0);

	$r = preg_replace('/\s+$/', '', $r);

	return $r;
}

/**
 *	smarty modifier:i18nե륿
 *
 *	sample:
 *	<code>
 *	{"english"|i18n}
 *	</code>
 *	<code>
 *	Ѹ
 *	</code>
 *
 *	@param	string	$string	i18nоݤʸ
 *	@return	string	бå
 */
function smarty_modifier_i18n($string)
{
	$c =& Ethna_Controller::getInstance();

	$i18n =& $c->getI18N();

	return $i18n->get($string);
}

/**
 *	smarty modifier:åܥåѥե륿
 *
 *	sample:
 *	<code>
 *	<input type="checkbox" name="test" {""|checkbox}>
 *	<input type="checkbox" name="test" {"1"|checkbox}>
 *	</code>
 *	<code>
 *	<input type="checkbox" name="test">
 *	<input type="checkbox" name="test" checkbox>
 *	</code>
 *
 *	@param	string	$string	åܥåϤ줿ե
 *	@return	string	$stringʸ󤢤뤤0ʳξ"checked"
 */
function smarty_modifier_checkbox($string)
{
	if ($string != "" && $string != 0) {
		return "checked";
	}
}

/**
 *	smarty modifier:쥯ȥܥåѥե륿
 *
 *	ñʥ쥯ȥܥåξsmartyؿ"select"Ѥ뤳Ȥ
 *	άǽ
 *
 *	sample:
 *	<code>
 *	$smarty->assign("form", 1);
 *
 *	<option value="1" {$form|select:"1"}>foo</option>
 *	<option value="2" {$form|select:"2"}>bar</option>
 *	</code>
 *	<code>
 *	<option value="1" selected>foo</option>
 *	<option value="2" >bar</option>
 *	</code>
 *
 *	@param	string	$string	쥯ȥܥåϤ줿ե
 *	@param	string	$value	<option>˻ꤵƤ
 *	@return	string	$string$value˥ޥå"selected"
 */
function smarty_modifier_select($string, $value)
{
	if ($string == $value) {
		print "selected";
	}
}

/**
 *	smarty modifier:եͽϥե륿
 *
 *	ե̾ѿǻꤷƥեͤ˻Ѥ
 *
 *	sample:
 *	<code>
 *	$this->af->set('foo', 'bar);
 *	$smarty->assign('key', 'foo');
 *	{$key|form_value}
 *	</code>
 *	<code>
 *	bar
 *	</code>
 *
 *	@param	string	$string	ե̾
 *	@return	string	ե
 */
function smarty_modifier_form_value($string)
{
	$c =& Ethna_Controller::getInstance();
	$af =& $c->getActionForm();

	$elts = explode(".", $string);
	$r = $af->get($elts[0]);
	for ($i = 1; $i < count($elts); $i++) {
		$r = $r[$elts[$i]];
	}

	return htmlspecialchars($r);
}

/**
 *	smarty function:ꤵ줿եܤǥ顼ȯƤ뤫ɤ֤
 *
 *	sample:
 *	<code>
 *  {if is_error('name')}
 *  顼
 *  {/if}
 *	</code>
 *
 *	@param	string	$name	ե̾
 */
function smarty_function_is_error($params, &$smarty)
{
	$c =& Ethna_Controller::getInstance();

	extract($params);

	$action_error =& $c->getActionError();

	return $action_error->isError($name);
}

/**
 *	smarty function:ꤵ줿եܤб륨顼åϤ
 *
 *	sample:
 *	<code>
 *	<input type="text" name="foo">{message name="foo"}
 *	</code>
 *	<code>
 *	<input type="text" name="foo">fooϤƤ
 *	</code>
 *
 *	@param	string	$name	ե̾
 */
function smarty_function_message($params, &$smarty)
{
	$c =& Ethna_Controller::getInstance();

	extract($params);

	$action_error =& $c->getActionError();

	print htmlspecialchars($action_error->getMessage($name));
}

/**
 *	smarty function:ˡID(double postå)
 *
 *	sample:
 *	<code>
 *	{uniqid}
 *	</code>
 *	<code>
 *	<input type="hidden" name="uniqid" value="a0f24f75e...e48864d3e">
 *	</code>
 *
 *	@param	string	$type	ɽ("get" or "post"ݥǥե="post")
 *	@see	isDuplicatePost
 */
function smarty_function_uniqid($params, &$smarty)
{
	extract($params);

	$uniqid = Ethna_Util::getRandom();
	if (isset($type) && $type == 'get') {
		print "uniqid=$uniqid";
	} else {
		print "<input type=\"hidden\" name=\"uniqid\" value=\"$uniqid\" />\n";
	}
}

/**
 *	smarty function:쥯ȥե
 *
 *	@param	array	$list	
 *	@param	string	$name	ե̾
 *	@param	string	$value	쥯ȥܥåϤ줿ե
 */
function smarty_function_select($params, &$smarty)
{
	extract($params);

	print "<select name=\"$name\">\n";
	foreach ($list as $id => $elt) {
		printf("<option value=\"%s\" %s>%s</option>\n", $id, $id == $value ? "selected" : "", $elt['name']);
	}
	print "</select>\n";
}

/**
 *	smarty function:åܥåե륿ؿ(б)
 *
 *	@param	string	$form	åܥåϤ줿ե
 *	@param	string	$key	ɾоݤ󥤥ǥå
 *	@param	string	$value	ɾ
 */
function smarty_function_checkbox_list($params, &$smarty)
{
	extract($params);

	if (isset($key) == false) {
		$key = null;
	}
	if (isset($value) == false) {
		$value = null;
	}
	if (isset($checked) == false) {
		$checked = "checked";
	}

	if (is_null($key) == false) {
		if (isset($form[$key])) {
			if (is_null($value)) {
				print $checked;
			} else {
				if (strcmp($form[$key], $value) == 0) {
					print $checked;
				}
			}
		}
	} else if (is_null($value) == false) {
		if (is_array($form)) {
			if (in_array($value, $form)) {
				print $checked;
			}
		} else {
			if (strcmp($value, $form) == 0) {
				print $checked;
			}
		}
	}
}
?>
