<?php
// vim: foldmethod=marker
/**
 *	Ethna_Session.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_Session.php,v 1.3 2005/01/06 17:44:23 fujimoto Exp $
 */

// {{{ Ethna_Session
/**
 *	å󥯥饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_Session
{
	/**#@+
	 *	@access	private
	 */

	/**	@var	object	Ethna_Logger	logger֥ */
	var	$logger;

	/**	@var	string	å̾ */
	var $session_name;

	/**	@var	string	åǡ¸ǥ쥯ȥ */
	var	$session_save_dir;

	/**	@var	bool	å󳫻ϥե饰 */
	var $session_start = false;

	/**	@var	bool	ƿ̾åե饰 */
	var $anonymous = false;

	/**#@-*/

	/**
	 *	Ethna_Session饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	string	$appid		ץꥱID(å̾Ȥƻ)
	 *	@param	string	$save_dir	åǡ¸ǥ쥯ȥ
	 */
	function Ethna_Session($appid, $save_dir, $logger)
	{
		$this->session_name = "${appid}SESSID";
		$this->session_save_dir = $save_dir;
		$this->logger =& $logger;

		if ($this->session_save_dir != "") {
			session_save_path($this->session_save_dir);
		}

		session_name($this->session_name);
		session_cache_limiter('private, must-revalidate');

		$this->session_start = false;
		if (isset($_SERVER['REQUEST_METHOD']) == false) {
			return;
		}

		if (strcasecmp($_SERVER['REQUEST_METHOD'], 'post') == 0) {
			$http_vars =& $_POST;
		} else {
			$http_vars =& $_GET;
		}
		if (array_key_exists($this->session_name, $http_vars) && $http_vars[$this->session_name] != null) {
			$_COOKIE[$this->session_name] = $http_vars[$this->session_name];
		}

		if (!empty($_COOKIE[$this->session_name]) || session_id() != null) {
			session_start();
			$this->session_start = true;

			// check session
			if ($this->isValid() == false) {
				setcookie($this->session_name, "", 0, "/");
				$this->session_start = false;
			}

			// check anonymous
			if ($this->get('__anonymous__')) {
				$this->anonymous = true;
			}
		}
	}

	/**
	 *	åå
	 *
	 *	@access	public
	 *	@return	bool	true:ʥå false:ʥå
	 */
	function isValid()
	{
		if (!$this->session_start) {
			if (!empty($_COOKIE[$this->session_name]) || session_id() != null) {
				setcookie($this->session_name, "", 0, "/");
			}
			return false;
		}

		// check remote address
		if (!isset($_SESSION['REMOTE_ADDR']) || $this->_validateRemoteAddr($_SESSION['REMOTE_ADDR'], $_SERVER['REMOTE_ADDR']) == false) {
			// we do not allow this
			setcookie($this->session_name, "", 0, "/");
			session_destroy();
			$this->session_start = false;
			return false;
		}

		return true;
	}

	/**
	 *	å򳫻Ϥ
	 *
	 *	@access	public
	 *	@param	int		$lifetime	åͭ(ñ, 0ʤ饻å󥯥å)
	 *	@return	bool	true:ｪλ false:顼
	 */
	function start($lifetime = 0, $anonymous = false)
	{
		if ($this->session_start) {
			// we need this?
			$_SESSION['REMOTE_ADDR'] = $_SERVER['REMOTE_ADDR'];
			$_SESSION['__anonymous__'] = $anonymous;
			return true;
		}

		if (is_null($lifetime)) {
			ini_set('session.use_cookies', 0);
		} else {
			ini_set('session.use_cookies', 1);
		}

		session_set_cookie_params($lifetime);
		session_id(Ethna_Util::getRandom());
		session_start();
		$_SESSION['REMOTE_ADDR'] = $_SERVER['REMOTE_ADDR'];
		$_SESSION['__anonymous__'] = $anonymous;
		$this->session_start = true;

		return true;
	}

	/**
	 *	å˴
	 *
	 *	@access	public
	 *	@return	bool	true:ｪλ false:顼
	 */
	function destroy()
	{
		if (!$this->session_start) {
			return true;
		}
		
		session_destroy();
		$this->session_start = false;
		setcookie($this->session_name, "", 0, "/");

		return true;
	}

	/**
	 *	åͤؤΥ(R)
	 *
	 *	@access	public
	 *	@param	string	$name	
	 *	@return	mixed	(null:å󤬳ϤƤʤ)
	 */
	function get($name)
	{
		if (!$this->session_start) {
			return null;
		}

		if (!isset($_SESSION[$name])) {
			return null;
		}
		return $_SESSION[$name];
	}

	/**
	 *	åͤؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$name	
	 *	@param	string	$value	
	 *	@return	bool	true:ｪλ false:顼(å󤬳ϤƤʤ)
	 */
	function set($name, $value)
	{
		if (!$this->session_start) {
			// no way
			return false;
		}

		$_SESSION[$name] = $value;

		return true;
	}

	/**
	 *	åͤ˴
	 *
	 *	@access	public
	 *	@param	string	$name	
	 *	@return	bool	true:ｪλ false:顼(å󤬳ϤƤʤ)
	 */
	function remove($name)
	{
		if (!$this->session_start) {
			return false;
		}

		unset($_SESSION[$name]);

		return true;
	}

	/**
	 *	å󤬳ϤƤ뤫ɤ֤
	 *
	 *	@access	public
	 *	@param	string	$anonymous	ƿ̾åֳϡפȤߤʤɤ(default: false)
	 *	@return	bool	true:ϺѤ false:ϤƤʤ
	 */
	function isStart($anonymous = false)
	{
		if ($anonymous) {
			return $this->session_start;
		} else {
			if ($this->session_start && $this->isAnonymous() != true) {
				return true;
			} else {
				return false;
			}
		}
	}

	/**
	 *	ƿ̾å󤫤ɤ֤
	 *
	 *	@access	public
	 *	@return	bool	true:ƿ̾å false:ƿ̾å/å󳫻ϤƤʤ
	 */
	function isAnonymous()
	{
		return $this->anonymous;
	}

	/**
	 *	å¸줿IPɥ쥹ȥIPɥ쥹ƱͥåȥϰϤɤȽ̤(16bit mask)
	 *
	 *	@access	private
	 *	@param	string	$src_ip		å󳫻ϻΥIPɥ쥹
	 *	@param	string	$dst_ip		ߤΥIPɥ쥹
	 *	@return	bool	true:ｪλ false:IPɥ쥹
	 */
	function _validateRemoteAddr($src_ip, $dst_ip)
	{
		$src = ip2long($src_ip);
		$dst = ip2long($dst_ip);

		if (($src & 0xffff0000) == ($dst & 0xffff0000)) {
			return true;
		} else {
			$this->logger(LOG_NOTICE, "session IP validation failed [%s] - [%s]", $src_ip, $dst_ip);
			return false;
		}
	}
}
// }}}
?>
