using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.Sub
{

	internal enum TokenType
	{
		Null = 0,
		Numeric = 1,
		Identifer = 2,
		EndOfLine = 3,
		WhiteSpace = 4,
		Operator = 5,
		StartOfExpression = 6,
		EndOfExpression = 7,
		EtcSymbol = 9,
		StringToken = 10,
		StringFormToken = 11,
		EndOfString = 12,
	}

	internal static class TokenReader
	{
		readonly static char[] operators = new char[] { '+', '-', '*', '/', '%', '=', '!', '<', '>', '|', '&', '^', '~', '?', '#'};
		readonly static char[] whiteSpaces = new char[] { ' ', '@', '\t' };
		readonly static char[] endOfExpression = new char[] { ')', '}', ']', ',', ':' };
		readonly static char[] startOfExpression = new char[] { '(' };
		readonly static char[] stringToken = new char[] { '\"', };
		readonly static char[] stringFormToken = new char[] { '@', };
		readonly static char[] etcSymbol = new char[] { '(', '[', '{', '$', '\\', '$', };
		readonly static char[] decimalDigits = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', };
		readonly static char[] hexadecimalDigits = { 'a', 'b', 'c', 'd', 'e', 'f', 'A', 'B', 'C', 'D', 'E', 'F' };

		public static SingleTerm ReadInt64(StringStream st)
		{
			Int64 significand = 0;
			int expBase = 0;
			int exponent = 0;
			int stStartPos = st.CurrentPosition;
			int stEndPos = st.CurrentPosition;
			int fromBase = 10;
			if (st.Current == '0')
			{
				char c = st.Next;
				if ((c == 'x') || (c == 'X'))
				{
					fromBase = 16;
					st.ShiftNext();
					st.ShiftNext();
				}
				else if ((c == 'b') || (c == 'B'))
				{
					fromBase = 2;
					st.ShiftNext();
					st.ShiftNext();
				}
				//8i@̖͌݊肩̗pȂB
				//else if (((IList<char>)decimalDigits).Contains(c))
				//{
				//    fromBase = 8;
				//    st.ShiftNext();
				//}
			}

			significand = readDigits(st, fromBase);
			if ((st.Current == 'p') || (st.Current == 'P'))
				expBase = 2;
			else if ((st.Current == 'e') || (st.Current == 'E'))
				expBase = 10;
			if (expBase != 0)
			{
				st.ShiftNext();
				unchecked { exponent = (int)readDigits(st, fromBase); }
			}
			stEndPos = st.CurrentPosition;
			if ((expBase != 0) && (exponent != 0))
			{
				double d = significand * Math.Pow(expBase, exponent);
				if ((double.IsNaN(d)) || (double.IsInfinity(d)) || (d > Int64.MaxValue) || (d < Int64.MinValue))
					throw new CodeEE("\"" + st.Substring(stStartPos, stEndPos) + "\"64rbgt͈̔͂𒴂Ă܂");
				significand = (Int64)d;
			}
			return new SingleTerm(significand);
		}


		private static Int64 readDigits(StringStream st, int fromBase)
		{
			StringBuilder buffer = new StringBuilder();
			char c = st.Current;
			if ((c == '-') || (c == '+'))
			{
				buffer.Append(c);
				st.ShiftNext();
			}
			if (fromBase == 10)
			{
				while (!st.EOS)
				{
					c = st.Current;
					if (((IList<char>)decimalDigits).Contains(c))
					{
						buffer.Append(c);
						st.ShiftNext();
						continue;
					}
					break;
				}
			}
			else if (fromBase == 16)
			{
				while (!st.EOS)
				{
					c = st.Current;
					if ((((IList<char>)decimalDigits).Contains(c)) || (((IList<char>)hexadecimalDigits).Contains(c)))
					{
						buffer.Append(c);
						st.ShiftNext();
						continue;
					}
					break;
				}
			}
			else if (fromBase == 2)
			{
				while (!st.EOS)
				{
					c = st.Current;
					if (((IList<char>)decimalDigits).Contains(c))
					{
						if ((c != '0') && (c != '1'))
							throw new CodeEE("i@\L̒ŎgpłȂgĂ܂");
						buffer.Append(c);
						st.ShiftNext();
						continue;
					}
					break;
				}
			}
			try
			{
				return Convert.ToInt64(buffer.ToString(), fromBase);
			}
			catch(FormatException)
			{
				throw new CodeEE("\"" + buffer.ToString() + "\"͐lɕϊł܂");
			}
			catch (OverflowException)
			{
				throw new CodeEE("\"" + buffer.ToString() + "\"64rbgt͈̔͂𒴂Ă܂");
			}
		}


		/// <summary>
		/// 
		/// </summary>
		/// <param name="st"></param>
		/// <param name="d"></param>
		/// <returns></returns>
		public static double ReadDouble(StringStream st)
		{
			//GcɓǂݍŃG[ConvertNXɔCB
			//
			StringBuilder buffer = new StringBuilder();

			if (st.Current == '-')
			{
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			while (!st.EOS)
			{//
				char c = st.Current;
				if ((((IList<char>)decimalDigits).Contains(c)) || (c == '.'))
				{
					buffer.Append(c);
					st.ShiftNext();
					continue;
				}
				break;
			}
			if ((st.Current == 'e') || (st.Current == 'E'))
			{

				buffer.Append(st.Current);
				st.ShiftNext();
				if (st.Current == '-')
				{
					buffer.Append(st.Current);
					st.ShiftNext();
				}
				while (!st.EOS)
				{//w
					char c = st.Current;
					if ((((IList<char>)decimalDigits).Contains(c)) || (c == '.'))
					{
						buffer.Append(c);
						st.ShiftNext();
						continue;
					}
					break;
				}
			}

			//gp̂TIMESQ݂̂Ȃ̂Łc
			//try
			//{
				return Convert.ToDouble(buffer.ToString());
			//}
			//catch
			//{
			//    throw new CodeEE("\"" + buffer.ToString() + "\"lɕϊł܂ł");
			//}
		}

		public static int SkipWhiteSpace(StringStream st)
		{
			int count = 0;
			while (((IList<char>)whiteSpaces).Contains(st.Current))
			{
				count++;
				st.ShiftNext();
			}
			return count;
		}

        public static int SkipHalfSpace(StringStream st)
        {
            int count = 0;
            while (st.Current == ' ')
            {
                count++;
                st.ShiftNext();
            }
            return count;
        }

		/// <summary>
		/// sEmueraOperatorType.NULL
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static OperatorCode ReadOperator(StringStream st)
		{
			string opStr = ReadOperatorString(st);
			OperatorCode ret = OperatorManager.ToOperatorType(opStr);
			if (ret == OperatorCode.NULL)
				throw new CodeEE("\"" + opStr + "\"͉ZqƂĔFł܂");
			return ret;
		}

		//Zq̂
		public static string ReadOperatorString(StringStream st)
		{
			StringBuilder buffer = new StringBuilder();
			while (((IList<char>)operators).Contains(st.Current))
			{
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			return buffer.ToString();
		}

		/// <summary>
		/// snull
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static string ReadSingleIdentifer(StringStream st)
		{
			StringBuilder buffer = new StringBuilder();
			while (!st.EOS)
			{
				char c = st.Current;
				if (((IList<char>)whiteSpaces).Contains(c))
					break;
				if (((IList<char>)operators).Contains(c))
					break;
				if (((IList<char>)endOfExpression).Contains(c))
					break;
				if (((IList<char>)etcSymbol).Contains(c) && c != '@')
					throw new CodeEE("ʎqɕsȕgĂ܂");
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			return buffer.ToString();
		}

		/// <summary>
		/// snull
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static string ReadIdentiferWithIndex(StringStream st)
		{
			StringBuilder buffer = new StringBuilder();
			int bracetNest = 0;
			while (!st.EOS)
			{
				char c = st.Current;
				if (bracetNest > 0)
				{//ʂ̒Ȃ牽łA̕ϐ̈ꕔƌȂ
					buffer.Append(st.Current);
					st.ShiftNext();
                    if (c == '(')
                    {
                        bracetNest++;
                    }
                    else if (c == ')')
                    {
                        bracetNest--;
                    }
					continue;
				}
				if (c == '(')
				{
					buffer.Append(st.Current);
					st.ShiftNext();
					bracetNest++;
					continue;
				}
				if (((IList<char>)whiteSpaces).Contains(c))
					break;
				if (((IList<char>)operators).Contains(c))
					break;
				if ( ((IList<char>)endOfExpression).Contains(c) && (c != ':'))
					break;
				if (((IList<char>)etcSymbol).Contains(c) && c != '@')
					throw new CodeEE("ʎqɕsȕgĂ܂");
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			return buffer.ToString();
		}

		///// <summary>
		///// snull
		///// </summary>
		///// <param name="st"></param>
		///// <returns></returns>
		//public static string ReadIdentiferWithIndexAndExpression(StringStream st)
		//{
		//    StringBuilder buffer = new StringBuilder();
		//    int bracetNest = 0;
		//    bool formExpression = false;
		//    bool formSExpression = false;
		//    bool inRawString = false;
		//    while (!st.EOS)
		//    {
		//        char c = st.Current;
		//        if (bracetNest > 0)
		//        {//ʂ̒Ȃ牽łA̕ϐ̈ꕔƌȂ
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            if (c == '(')
		//            {
		//                bracetNest++;
		//            }
		//            else if (c == ')')
		//            {
		//                bracetNest--;
		//            }
		//            continue;
		//        }
		//        if (formExpression)
		//        {//{}͈̒Ɉ
		//            if (c == '{')
		//                throw new ExeEE("{}{͏d܂");
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            if (c == '}')
		//                formExpression = false;
		//            if (c == '(')
		//                bracetNest++;
		//            continue;
		//        }
		//        if (formSExpression)
		//        {//%%͈̒Ɉ
		//            if (c == '{' || c == '}')
		//                throw new ExeEE("%%" + c + "͊܂݂܂");
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            if (c == '\"')
		//                inRawString = !inRawString;
		//            if (c == '%' && !inRawString)
		//                formSExpression = false;
		//            if (c == '(')
		//                bracetNest++;
		//            continue;
		//        }
		//        if (c == '(')                {
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            bracetNest++;
		//            continue;
		//        }
		//        if (c == '{' && !formExpression)
		//        {
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            formExpression = true;
		//            continue;
		//        }
		//        if (c == '%' && !formExpression)
		//        {
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            formSExpression = !formSExpression;
		//            continue;
		//        }
		//       if (((IList<char>)whiteSpaces).Contains(c))
		//            break;
		//        if (((IList<char>)operators).Contains(c) && c != '%')
		//            break;
		//        if (((IList<char>)endOfExpression).Contains(c) && c != ':')
		//            break;
		//        if (((IList<char>)etcSymbol).Contains(c) && c != '@')
		//            throw new CodeEE("ʎqɕsȕgĂ܂");
		//        buffer.Append(st.Current);
		//        st.ShiftNext();
		//    }
		//    return buffer.ToString();
		//}

        /// <summary>
		/// \"Ŏn܂\"ŏI镶B{Ƃ̕@ɂ͂ȂB
		/// "̓GXP[vׂ
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		internal static string ReadStringWithDoubleQuotation(StringStream st)
		{
			if (st.Current != '\"')
				throw new ExeEE("\"Ŏn܂ĂȂ̂ɃeƂĈꂽ");
			st.ShiftNext();
			StringBuilder buffer = new StringBuilder();
			while (st.Current != '\"')
			{
				char c = st.Current;
				if (st.EOS)
					throw new CodeEE("\"Ă܂");
				if (st.Current == '\\')//GXP[v
				{
					st.ShiftNext();//\ǂݔ΂
					switch (st.Current)
					{
						case StringStream.EndOfString:
							throw new CodeEE("GXP[v\\̌ɕ܂");
						case '\n':
							break;
						case 's':
							buffer.Append(' ');
							break;
						case 'S':
							buffer.Append('@');
							break;
						case 't':
							buffer.Append('\t');
							break;
						case 'n':
							buffer.Append('\n');
							break;
						default:
							buffer.Append(st.Current);
							break;
					}
					st.ShiftNext();//\̎̕ǂݔ΂
					continue;
				}
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			st.ShiftNext();
			return buffer.ToString();
		}

		/// <summary>
		/// 蕶ŏI镶BsplitternullȂ,؂蕶Bprintv'Ŏn܂镶Ȃ
		/// </summary>
		/// <param name="st"></param>
		/// <returns></returns>
		public static string ReadStringEndWith(StringStream st, char[] splitter)
		{
			StringBuilder buffer = new StringBuilder();
			if (splitter == null)
				splitter = new char[] { ',' };
			while (!st.EOS)
			{
				char c = st.Current;
				if (((IList<char>)splitter).Contains(c))
					break;
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			return buffer.ToString();
		}

		///// <summary>
		///// ֐̐B
		///// </summary>
		///// <param name="st"></param>
		///// <returns></returns>
		//public static string ReadRawString(StringStream st)
		//{
		//    StringBuilder buffer = new StringBuilder();
		//    while (!st.EOS)
		//    {
		//        char c = st.Current;
		//        if (((IList<char>)whiteSpaces).Contains(c))
		//            break;
		//        buffer.Append(st.Current);
		//        st.ShiftNext();
		//    }
		//    return buffer.ToString();
		//}

		///// <summary>
		///// ֐Form\݂̕B
		///// </summary>
		///// <param name="st"></param>
		///// <returns></returns>
		//public static string ReadRawStringWithFormString(StringStream st)
		//{
		//    int bracetNest = 0;
		//    bool formExpression = false;
		//    bool formSExpression = false;
		//    bool inRawString = false;
		//    StringBuilder buffer = new StringBuilder();
		//    while (!st.EOS)
		//    {
		//        char c = st.Current;
		//        if (bracetNest > 0)
		//        {//ʂ̒Ȃ牽łA̕ϐ̈ꕔƌȂ
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            if (c == '(')
		//            {
		//                bracetNest++;
		//            }
		//            else if (c == ')')
		//            {
		//                bracetNest--;
		//            }
		//            continue;
		//        }
		//        if (formExpression)
		//        {//{}͈̒Ɉ
		//            if (c == '{')
		//                throw new ExeEE("{}{͏d܂");
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            if (c == '}')
		//                formExpression = false;
		//            if (c == '(')
		//                bracetNest++;
		//            continue;
		//        }
		//        if (formSExpression)
		//        {//%%͈̒Ɉ
		//            if (c == '{' || c == '}')
		//                throw new ExeEE("%%" + c + "͊܂݂܂");
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            if (c == '\"')
		//                inRawString = !inRawString;
		//            if (c == '%' && !inRawString)
		//                formSExpression = false;
		//            if (c == '(')
		//                bracetNest++;
		//            continue;
		//        }
		//        if (c == '(')
		//        {
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            bracetNest++;
		//            continue;
		//        }
		//        if (c == '{' && !formExpression)
		//        {
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            formExpression = true;
		//            continue;
		//        }
		//        if (c == '%' && !formExpression)
		//        {
		//            buffer.Append(st.Current);
		//            st.ShiftNext();
		//            formSExpression = !formSExpression;
		//            continue;
		//        } 
		//        if (((IList<char>)whiteSpaces).Contains(c))
		//            break;
		//        buffer.Append(st.Current);
		//        st.ShiftNext();
		//    }
		//    return buffer.ToString();
		//}
        
        public static bool IsWhiteSpace(char c)
		{
			if (((IList<char>)whiteSpaces).Contains(c))
				return true;
			return false;
		}

		public static TokenType GetNextTokenType(StringStream st)
		{
			if (st.EOS)
				return TokenType.EndOfString;
			char current = st.Current;
			if (current == '\n')
				return TokenType.EndOfLine;
			if (((IList<char>)decimalDigits).Contains(current))
				return TokenType.Numeric;
			if (((IList<char>)operators).Contains(current))
				return TokenType.Operator;
			if (((IList<char>)whiteSpaces).Contains(current))
				return TokenType.WhiteSpace;
			if (((IList<char>)startOfExpression).Contains(current))
				return TokenType.StartOfExpression;
			if (((IList<char>)endOfExpression).Contains(current))
				return TokenType.EndOfExpression;
			if (((IList<char>)etcSymbol).Contains(current))
				return TokenType.EtcSymbol;
			if (((IList<char>)stringToken).Contains(current))
				return TokenType.StringToken; ;
			if (((IList<char>)stringFormToken).Contains(current))
				return TokenType.StringFormToken;
			return TokenType.Identifer;

		}

	}
}
