using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace MinorShift.Emuera.Sub
{
	//BEraMakerEx̎dlĂB
	//
#if USE_SYNONYM
	public sealed class SysnonymManager
	{

		Dictionary<string, string> synonymWordDic = new Dictionary<string, string>();
		List<Synonym> synonymList = new List<Synonym>();
		public void LoadSynonymFile(string filepath)
		{
			if (!File.Exists(filepath))
				return;
			string filename = Path.GetFileName(filepath);
			StreamReader reader = null;
			string line = null;
			ScriptPosition pos = null;
			int lineNo = 0;
			try
			{
				reader = new StreamReader(filepath, Config.Encode);
				while ((line = reader.ReadLine()) != null)
				{
					lineNo++;
					if (line.Length == 0)
						continue;
					if (line.StartsWith(";"))
						continue;
					string[] tokens = line.Split(',');
					if (tokens.Length < 2)
						continue;
					pos = new ScriptPosition(filename, lineNo, line);
					//EraEx̋L@Ƃ͋tɂȂ
					string value = tokens[0].Trim();
					string key = tokens[1].Trim();
					addSynonym(key, value);
					pos = null;

				}
			}
			catch (Exception e)
			{
				if (pos != null)
					throw new CodeEE(e.Message, pos);
				else
					throw new CodeEE(e.Message);

			}
			finally
			{
				if (reader != null)
					reader.Close();
			}

		}

		private void addSynonym(string key, string value)
		{
			string[] left = key.Split(':');
			string[] right = value.Split(':');
			if ((left.Length == 1) && (right.Length == 1))
			{
				if (Config.IgnoreCase)
					left[0] = left[0].ToUpper();
				if (synonymWordDic.ContainsKey(left[0]))
					throw new CodeEE("ϊ\"" + key + "\"͊ɓo^Ă܂");
				synonymWordDic.Add(left[0], value);
				return;
			}
			int hatenaCount = 0;
			for (int i = 0; i < left.Length; i++)
			{
				if (left[i] == "?")
				{
					hatenaCount++;
					left[i] = null;
				}
			}
			if (hatenaCount >= 2)
				throw new CodeEE("ϊ\"" + key + "\"͕?܂܂Ă܂");
			int rightHatenaCount = 0;
			for (int i = 0; i < right.Length; i++)
			{
				if (right[i] == "?")
				{
					rightHatenaCount++;
					right[i] = null;
				}
			}
			if (rightHatenaCount >= 2)
				throw new CodeEE("ϊ\"" + value + "\"ɂ͕?܂܂Ă܂");
			if (rightHatenaCount > hatenaCount)
				throw new CodeEE("ϊ\"" + value + "\"ɂ̂?܂܂Ă܂");
			Synonym s = new Synonym(left, right);
			foreach (Synonym syn in synonymList)
				if (s.EqualTo(syn))
					throw new Exception("\"" + key + "\"͊ɓo^Ă܂");
			synonymList.Add(s);
			return;
		}

		public string[] ApplySynonym(string[] id)
		{
			if ((synonymList.Count == 0) && (synonymWordDic.Count == 0))
				return id;
			string[] ret = id;
			List<Synonym> synList = new List<Synonym>();
			Synonym syn = null;
			foreach (Synonym s in synonymList)
			{
				if (s.IsAvailable(id))
				{
					synList.Add(s);
					if (!s.HasHatena)
						syn = s;
				}
			}
			if (synList.Count != 0)
			{
				if (synList.Count == 1)
				{
					ret = synList[0].Apply(id);
				}
				else
				{
					if (syn == null)
					{
						string key = id[0];
						for (int i = 1; i < id.Length; i++)
							key += ":" + id[i];
						throw new CodeEE("\"" + key + "\"ɂ̓Vmj₪܂");
					}
					syn.Apply(id);
				}
			}
			for (int i = 0; i < ret.Length; i++)
			{
				string key = ret[i];
				if (Config.IgnoreCase)
					key = ret[i].ToUpper();
				if (synonymWordDic.ContainsKey(key))
					ret[i] = synonymWordDic[key];
			}
			return ret;
		}

		private sealed class Synonym
		{
			public Synonym(string[] key, string[] value)
			{
				left = key;
				right = value;
				foreach (string s in key)
					if (s == null)
						hasHatena = true;
			}
			readonly string[] left;//ϊ
			readonly string[] right;//ϊ
			readonly bool hasHatena;
			public bool HasHatena { get { return hasHatena; } }
			public bool EqualTo(Synonym rother)
			{
				if (left.Length != rother.left.Length)
					return false;
				StringComparison comparison = StringComparison.Ordinal;
				if (Config.IgnoreCase)
					comparison = StringComparison.OrdinalIgnoreCase;
				for (int i = 0; i < left.Length; i++)
				{
					if ((left[i] == null) && (rother.left[i] == null))
						continue;
					if (!string.Equals(left[i], rother.left[i], comparison))
						return false;
				}
				return true;
			}

			public bool IsAvailable(string[] candidate)
			{
				if (left.Length != candidate.Length)
					return false;
				StringComparison comparison = StringComparison.Ordinal;
				if (Config.IgnoreCase)
					comparison = StringComparison.OrdinalIgnoreCase;
				for (int i = 0; i < left.Length; i++)
				{
					if (left[i] == null)
						continue;
					if (!string.Equals(left[i], candidate[i], comparison))
						return false;
				}
				return true;
			}

			///IsAvailable == trueOɓB
			public string[] Apply(string[] target)
			{
				string[] ret = new string[right.Length];
				ret[0] = right[0];
				for (int i = 1; i < ret.Length; i++)
				{
					if (right[i] != null)
					{
						ret[i] = right[i];
						continue;
					}
					for (int j = 0; j < left.Length; j++)
					{
						if (left[j] != null)
							continue;
						ret[i] = target[j];
						break;
					}
				}
				return ret;
			}
		}
#else
	public sealed class SysnonymManager
	{

		public string[] ApplySynonym(string[] id)
		{
			return id;
		}
	}

#endif
}
