using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.Sub;

namespace MinorShift.Emuera.GameData
{
	internal sealed class StringForm
	{
		public StringForm(string row)
		{
			rowString = row;
		}

		string rowString;
		public string RowString { get { return rowString; } }
		string formString;
		List<IOperandTerm> argList = new List<IOperandTerm>();
		List<bool> isTernary = new List<bool>();

		public bool Reduced
		{
			get
			{
				return formString != null;
			}
		}

		private VariableToken getVariable(VariableCode code, VariableCode subCode)
		{
			VariableIdentifier subId = VariableIdentifier.GetVariableId(subCode);
			VariableToken subToken = new VariableToken(subId, new SingleTerm(0), null);
			VariableIdentifier id = VariableIdentifier.GetVariableId(VariableCode.NAME);
			VariableToken token = new VariableToken(id, subToken, null);
			return token;
		}

		public void Reduce()
		{
			Reduce(new StringStream(rowString), '\0');
		}
		public void Reduce(StringStream st, char endKey)
		{
			int start = st.CurrentPosition;
			if (this.Reduced)
				return;
			StringBuilder buffer = new StringBuilder();
			int countArg = 0;
			while (!st.EOS && (st.Current != endKey))
			{
				if (st.Current == '%')
				{
					st.ShiftNext();
					argList.Add(ExpressionParser.ReduceStringTerm(st));
					isTernary.Add(false);
					TokenReader.SkipWhiteSpace(st);
					if (st.Current != '%')
						throw new CodeEE("\'%\'g܂Ή\'%\'̏I[܂");
					st.ShiftNext();
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.Current == '{')
				{
					st.ShiftNext();
					argList.Add(ExpressionParser.ReduceIntegerTerm(st));
					isTernary.Add(false);
					TokenReader.SkipWhiteSpace(st);
					if (st.Current != '}')
						throw new CodeEE("\'{\'g܂Ή\'}\'܂");
					st.ShiftNext();
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.Current == '}')
				{
					throw new CodeEE("\'}\'g܂Ή\'{\'܂");
				}
				if (st.CurrentEqualTo("***"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.NAME, VariableCode.TARGET);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("+++"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.MASTER);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("==="))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.PLAYER);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("///"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.ASSI);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("$$$"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.TARGET);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				//GXP[v̎gp
				if (st.Current == '\\')
				{
					st.ShiftNext();
					switch (st.Current)
					{
						case StringStream.EndOfString:
							throw new CodeEE("GXP[v\\̌ɕ܂");
						case '\n':
							break;
						case 's':
							buffer.Append(' ');
							break;
						case 'S':
							buffer.Append('@');
							break;
						case 't':
							buffer.Append('\t');
							break;
						case 'n':
							buffer.Append('\n');
							break;
						case '{':
							buffer.Append('{');
							buffer.Append('{');
							break;
						case '}':
							buffer.Append('}');
							buffer.Append('}');
							break;
						case '@':
							bool isEscape = false;
							st.ShiftNext();
							StringBuilder tBf = new StringBuilder();
							while (!(st.Current == '@' && isEscape) && !st.EOS && (st.Current != endKey))
							{
								if (st.Current == '\\' && !isEscape)
								{
									isEscape = true;
									st.ShiftNext();
									continue;
								}
								if (isEscape)
								{
									switch (st.Current)
									{
										case StringStream.EndOfString:
											throw new CodeEE("GXP[v\\̌ɕ܂");
										case '\n':
											break;
										case 's':
											tBf.Append(' ');
											break;
										case 'S':
											tBf.Append('@');
											break;
										case 't':
											tBf.Append('\t');
											break;
										case 'n':
											tBf.Append('\n');
											break;
										case '{':
											tBf.Append('{');
											tBf.Append('{');
											break;
										case '}':
											tBf.Append('}');
											tBf.Append('}');
											break;
										default:
											tBf.Append(st.Current);
											break;
									}
									isEscape = false;
									st.ShiftNext();
									continue;
								}
								tBf.Append(st.Current);
								st.ShiftNext();
							}
							if (!(isEscape && st.Current == '@'))
								throw new CodeEE("Ή\\@܂");
							argList.Add(ExpressionParser.ReduceTernaryStringTerm(new StringStream(tBf.ToString())));
							isTernary.Add(true);
							buffer.Append("{");
							buffer.Append(countArg.ToString());
							buffer.Append("}");
							countArg++;
							break;
						default:
							buffer.Append(st.Current);
							break;
					}
					st.ShiftNext();
					continue;
				}
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			formString = buffer.ToString();
			if ((start != 0) || (!st.EOS))
				rowString = st.Substring(start, st.CurrentPosition - start);
		}

		public string GetString(ExpressionEvaluator eEvaluator)
		{
			if (!this.Reduced)
				this.Reduce();
			string[] objArgList = new string[argList.Count];
			for (int i = 0; i < objArgList.Length; i++)
			{
				IOperandTerm term = argList[i];
				if (term.GetOperandType() == typeof(Int64))
					objArgList[i] = eEvaluator.GetInteger(term).ToString();
				else if (term.GetOperandType() == typeof(string))
					if (isTernary[i])
					{
						StringForm tSf = new StringForm(eEvaluator.GetString(term));
						tSf.Reduce();
						objArgList[i] = tSf.GetString(eEvaluator);
					}
					else
						objArgList[i] = eEvaluator.GetString(term);
			}
			return string.Format(formString, objArgList);
		}
		public string Format
		{
			get
			{
				if (!this.Reduced)
					this.Reduce();
				return formString;
			}
		}

		public List<IOperandTerm> ArgList
		{
			get
			{
				if (!this.Reduced)
					this.Reduce();
				return argList;
			}
		}

	}
}