package jp.sourceforge.projects.ee2e.core.indent;

/**
 * Indentation fails for Javadoc
 * Javadoc comments are indented incorrectly. 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJavaCommentTest extends EE2EIndentJavaTest {

    /**
     * Constructor for EE2EIndentJavaCommentTest.
     * @param name
     */
    public EE2EIndentJavaCommentTest(String name) {
        super(name);
    }
    protected EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentJava(4,true);
    }
    /** public class */
    public void testDocPublicClass() {
        String base =
            "/**\n" +
            " * Comment.\n" +
            " */\n";
        String now = "public abstract class EE2EIndentJavaCommentTest extends EE2EIndentJavaTest";
        String answer = base + "" + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }
    /** public class */
    public void testDocPublicClassBefor() {
        String base =
            "/**\n" +
            " * Comment.\n";
        String now = "*/\n";
        String answer = base + " " + now;
        now = "    " + now; // dummy space
        this.doIndent(base, now, answer);
    }

    /** public class */
    public void testDocPublicClassBeforBefor() {
        String base =
            "/**\n";
        String now = "* Comment.\n";
        String answer = base + " " + now;
        now = "    " + now; // dummy space
        this.doIndent(base, now, answer);
    }

    /** between method */
    public void testDocBetweenMethod() {
        String base =
            "        fooBar();\n" +
            "    }\n" +
            "\n" +
            "    /**\n" +
            "     * Comment.\n" +
            "     */\n";
        String now = "public void getBoo() {";
        String answer = base + "    " + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }

    /** between method */
    public void testDocBetweenMethodBefor() {
        String base =
            "        fooBar();\n" +
            "    }\n" +
            "\n" +
            "    /**\n" +
            "     * Comment.\n";
        String now = "*/\n";
        String answer = base + "     " + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }

    /** between method */
    public void testDocBetweenMethodBeforBefor() {
        String base =
            "        fooBar();\n" +
            "    }\n" +
            "\n" +
            "    /**\n";
        String now = "* Comment.\n";
        String answer = base + "     " + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }
    
    /** between method */
    public void testDocBetweenMethodBeforX3() {
        String base =
            "        fooBar();\n" +
            "    }\n" +
            "\n";
        String now = "/**\n";
        String answer = base + "    " + now;
        now = "  " + now; // dummy space
        this.doIndent(base, now, answer);
    }
    
    /** comment check */
    public  void test1ThComment() {
        String base =
            "    }\n"
            + "\n";
        String now = "/** comment */";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** comment check */
    public  void testComment() {
        String base =
            "    hoge();\n"
            + "    }\n"
            + "    /**\n"
            + "     * foo bar\n"
            + "     * @see moemoe\n"
            + "     */\n";
        String now = "protected void doIndent() {";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** comment check */
    public  void testComment2() {
        String base =
            "    }\n"
            + "    /**\n"
            + "     * foo bar\n"
            + "     * @see moemoe\n";
        String now = "*/";
        String answer = base + "     " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** comment check */
    public  void testComment3() {
        String base =
            "    }\n"
            + "    /**\n"
            + "     * foo bar\n";
        String now = "* @see moemoe\n";
        String answer = base + "     " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** comment check */
    public  void testComment4() {
        String base =
            "    }\n"
            + "    /**\n";
        String now = "* foo bar\n";
        String answer = base + "     " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** comment check */
    public  void testComment5() {
        String base =
            "    }\n";
        String now = "/**\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    /** comment check */
    public  void testCommentConnma() {
        String base =
            "class BvhBody{\n"
            + "    friend class BvhFileData; // O0 'constructor\n";
        String now = "int work;\n";
        String answer = base + "    " + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
}
