package jp.sourceforge.projects.ee2e.core.indent;

import junit.framework.Assert;

/**
 * Abstract class for Java indent
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public abstract class EE2EIndentJavaTest extends EE2EIndentBaseTest {

	/**
	 * Constructor for EE2EIndentJavaTest.
	 * @param name
	 */
	public EE2EIndentJavaTest(String name) {
		super(name);
	}
    public void testIsQuoteToriger() throws EE2EIndentException {
        boolean isRedundantCircleFlag = true;
        EE2EIndentJava target = new EE2EIndentJava(4,isRedundantCircleFlag);
        //
        EE2EDocument document = this.createEE2EDocument("");
        boolean ans = target.isQuoteToriger(5,document);
        Assert.assertTrue(!ans);
        //
        document = this.createEE2EDocument("");
        ans = target.isQuoteToriger(-1,document);
        Assert.assertTrue(!ans);
        //
        String base = "\"";
        document = this.createEE2EDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "aaa\"";
        document = this.createEE2EDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "aaa\\\"";
        document = this.createEE2EDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(!ans);
        //
        base = "aaa\\\\\"";
        document = this.createEE2EDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(ans);
        //
        base = "aaa\\\\\\\"";
        document = this.createEE2EDocument(base + "  ");
        ans = target.isQuoteToriger(base.length() -1,document);
        Assert.assertTrue(!ans);        
    }
}
