package jp.sourceforge.projects.ee2e.core.indent;

/**
 * Indentation fails for circle mark.<br />
 * <br />
 * Until a punctuation mark appears for the first time,
 * the number of circle mark is counted.
 * Supposing the direction of a left circle mark is increases,
 * a space is moved to this position.<br />
 * <br />
 * (*) punctuation mark=="{","}"<br />
 * (*) circle mark=="(",")","[","]"<br />
 * <br />
 * (ex 1 -- Basic)<pre>
 *    Element a = new Element("b");
 *    Element c = new Element("d").
 *        addContent(new Element("e").
 *        addContent(new Element("f")));
 *    Element g = new Element("h");</pre>
 *
 * (ex 2 -- Advance)<pre>
 *    Element i = new Element("j");
 *    int k = new Element("l").
 *        getData() + (getElement("m").
 *        getData() + 
 *        this.getData());
 *    Element n = new Element("o");</pre>
 * 
 * (ex 3 -- Method)<pre>
 *    void test(int value1, 
 *        int value2) { 
 *        this.foo();
 *    }</pre>
 * 
 * (ex 4 -- Method call)<pre>
 *    this.foo();
 *    testMethods(1,
 *        2);
 *    this.bar();
 * </pre>
 * 
 * (ex 5 -- for/wile)<pre>
 *    for (int i = 0;
 *        (i &lt; 10) || (ch = ')');
 *        i++) {
 *        this.foo();</pre>
 * 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJavaCircleNextTest extends EE2EIndentJavaCircleTest {

    /**
     * Constructor for EE2EIndentJavaCommentTest.
     * @param name
     */
    public EE2EIndentJavaCircleNextTest(String name) {
        super(name);
    }
    /* (non-Javadoc)
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EIndentJavaTest#createEE2EIndentJava()
     */
    protected EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentJava(4,false);
    }
    public void testBasicBeforeX1() {
        String base =
            "    Element a = new Element(\"a\");\n" +
            "    Element b = new Element(\"c\").\n" +
            "        addContent(new Element(\"d\").\n";
        String now = "addContent(new Element(\"e\")));";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    public void testAdvanceBeforeX1() {
        String base =
            "    Element h = new Element(\"g\");\n" +
            "    int i = new Element(\"j\").\n" +
            "        getData() + (getElement(\"k\").\n" +
            "        getData() +\n";
        String now = "this.getData());";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    public void testAdvanceBeforeX2() {
        String base =
            "    Element h = new Element(\"g\");\n" +
            "    int i = new Element(\"j\").\n" +
            "        getData() + (getElement(\"k\").\n";
        String now = "getData() + ";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    public void testMethodBeforeX2() {
        String base =
            "    void test(int value1,\n";
        String now = "int value2) {";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    public void testMethodCallBefore() {
        String base =
            "    this.foo();\n" +
            "    testMethods(1,\n";
        String now = "2);";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    
    public void testForBeforeX1() {
        String base =
            "    for (\n" +
            "        int i = 0;\n" +
            "        i < 10 || (ch = ')');\n";
        String now = "i++) {";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }

    /** bug */
    public void testForBeforeX3() {
        String base =
            "    this.foo();" +
            "    for (\n" +
            "        int i = 0;\n";
        String now = "i < 10 || (ch = ')');";
        String answer = base + this.getSpace(4) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
    public void testForBeforeX4() {
        String base =
            "    for (\n";
        String now = "int i = 0;";
        String answer = base + this.getSpace(8) + now;
        now = "  " + now;
        this.doIndent(base, now, answer);
    }
}
