package jp.sourceforge.projects.ee2e.core.indent;
import junit.framework.Assert;

/**
 * Indentation fails for Javadoc
 * Javadoc comments are indented incorrectly. 
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EIndentJavaMethodTest extends EE2EIndentJavaTest {

    /**
     * Constructor for EE2EIndentJavaCommentTest.
     * @param name
     */
    public EE2EIndentJavaMethodTest(String name) {
        super(name);
    }
    protected EE2EIndentAction createEE2EIndent() {
        return new EE2EIndentJava(4,true);
    }

    public void testCheckCercle() throws EE2EIndentException {
        EE2EIndentJava indent = (EE2EIndentJava) this.createEE2EIndent();
        //
        EE2EDocument document = this.createEE2EDocument(
            "    for(\n" + "    int i = 0\n" + "i < 10;");
        int ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 8);
        //
        document = this.createEE2EDocument(
            "for(\n" + "{\n" + "hogehoge()");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, -1);
        //
        document = this.createEE2EDocument(
            "for(\n" + "}\n" + "hogehoge()");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, -1);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "1234(");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 5);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "1234((");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 6);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "1234(()) + 6789()");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, -1);
        //
        document = this.createEE2EDocument(
            "foo();\n" + ")");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, -1);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aa() + bb(");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 10);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aa() + bb(aaa,");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 10);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aaa( + bb()");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 4); 
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aa() + bb[1]");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, -1);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aa() + bb[");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 10);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aaa[ + bb()");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 4);
        //
        document = this.createEE2EDocument(
            "foo();\n" + "aaa[ + bb(\"[([(\" + cc( \'[\') )");
        ans = indent.checkCercle(document.getLength() -1 ,document);
        Assert.assertEquals(ans, 4);
    }
}
