package jp.sourceforge.projects.ee2e.core.indent;
import junit.framework.TestCase;
import junit.framework.Assert;

/**
 * Cpp mini format test.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECppMiniFormatBehaviorTest extends TestCase {
    public EE2ECppMiniFormatBehaviorTest(String name) {
        super(name);
    }
    
    public void testAfterSpace() {
        String base = "int hogehoge()    \n";
        String answer = "int hogehoge()\n";
        this.doIndent(base, answer);
    }

    public void testElese() {
        String base = "    }\n"
            + "    else\n"
            + "    {\n";
        String answer = "    } else {\n";
        this.doIndent(base, answer);
    }
    public void testEleseSpase() {
        String base = "    }\n"
            + "    else  \n"
            + "    {\n";
        String answer = "    } else {\n";
        this.doIndent(base, answer);
    }
    public void testIncludeIf() {
        String base =
            "    this.metiond();\n"
            + "    for (int i = 0 ; i < 10 ; i++)\n"
            + "#if 0\n"
            + "        {\n"
            + "        this.hoge();\n";
        String answer = base;
        this.doIndent(base, answer);
    }
    public void testFunction() {
        String base = "int hogehoge()\n"
            + "{\n";
        String answer = "int hogehoge() {\n";
        this.doIndent(base, answer);
    }
    
    public void doIndent(String base, String answer) {
        Assert.assertNotNull(base);
        EE2ECppMiniFormatBehavior target = new EE2ECppMiniFormatBehavior();
        try {
            answer = target.doBehavior(base);
        } catch (java.io.IOException e) {
            Assert.fail(e.getMessage());
        }
        String answerData = answer;
        Assert.assertEquals(answerData, answer);
    }

}
