package jp.sourceforge.projects.ee2e.core.indent;
import junit.framework.Assert;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2ECppStringTest extends EE2ECppDocumentTest {
    public EE2ECppStringTest(String name) {
        super(name);
    }
    public void testGetWriter() {
        super.testGetWriter();
        String target = "hogehoge";
        EE2ECppDocument document = this.createEE2ECppDocument(target);
        try {
            java.io.StringWriter sWriter = new java.io.StringWriter();
            document.getWriter(sWriter,true);
            sWriter.close();
            Assert.assertEquals(sWriter.toString() , target + "\n");
            //
            sWriter = new java.io.StringWriter();
            document.getWriter(sWriter,false);
            sWriter.close();
            Assert.assertEquals(sWriter.toString() , target + "\n");
        } catch (java.io.IOException e) {
            Assert.fail(e.getMessage());
        }
    }
    public EE2ECppDocument createEE2ECppDocument(String target) {
        return new EE2ECppString(target);
    }
}
