var express = require('express')
  , routes = require('./routes');

var app = module.exports = express.createServer();

// Configuration

app.configure(function(){
  app.set('views', __dirname + '/views');
  app.set('view engine', 'jade');
  app.use(express.bodyParser());
  app.use(express.methodOverride());
  app.use(app.router);
  app.use(express.static(__dirname + '/public'));
});

app.configure('development', function(){
  app.use(express.errorHandler({ dumpExceptions: true, showStack: true }));
});

app.configure('production', function(){
  app.use(express.errorHandler());
});

// Routes
app.get('/control', function(req, res) {
	res.render('control', {title:'Socket.IO Control'});
});
app.get('/recv', function(req, res) {
	res.render('recv', {title:'Socket.IO Receiver'});
});

// Socket.IO
var io = require('socket.io').listen(app);
var chats = [];
var sockets = {};
// broadcast function
function broadcast(method,message) {
	for (var n in sockets) {
    	sockets[n].emit(method,message);
	}
	chats.pop;
}

io
.of('/in')
.on('connection', function(socket) {
	sockets[socket.id] = socket;
	socket.on('control.add', function(data) {
    	    data.time = Date.now();
    	    chats.push(data);
    	    broadcast('control.add', data);
	});
	socket.on('disconnect', function() {
    	    delete sockets[socket.id];
	});
});


app.listen(8001);

console.log("Express server listening on port %d in %s mode", 8001, app.settings.env);
