/*
 * Decompiled with CFR 0.152.
 */
package daruma.wfs.filter;

import daruma.storage_manager.StorageException;
import daruma.storage_manager.StorageManager;
import daruma.storage_manager.type_definition.ColumnNameFactory;
import daruma.xml.QName;
import daruma.xml.SimpleXPath;
import daruma.xml.UniversalName;
import daruma.xml.util.ElementUtil;
import daruma.xml.util.NodeUtil;
import daruma.xml.util.XMLParseErrorException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyPathConverter {
    public static final String XPathSep = "/";
    public static final String XPathAttributePrefix = "@";
    public static final String XPathSystemColumnNamePrefix = "_";
    public static final String XPathSystemColumnPrefix = "@_";

    private PropertyPathConverter() {
    }

    public static String convertPropertyElementToShortXPath(Element element, StorageManager storage) throws XMLParseErrorException {
        String propertyNameString = ElementUtil.getChildNodesWholeText(element);
        return PropertyPathConverter.convertPropertyPathToShortXPath(propertyNameString, element, storage);
    }

    public static String convertPropertyPathToShortXPath(String propertyPathString, Node node, StorageManager storage) throws XMLParseErrorException {
        String columnName;
        if (propertyPathString.startsWith(XPathSystemColumnPrefix)) {
            return propertyPathString.substring(XPathAttributePrefix.length());
        }
        String[] propertyPathList = propertyPathString.trim().split(XPathSep);
        if (propertyPathList.length == 0) {
            throw new XMLParseErrorException("empty property path \"" + propertyPathString + "\"");
        }
        SimpleXPath path = new SimpleXPath();
        boolean addSrsName = false;
        for (String p : propertyPathList) {
            boolean isAttribute = false;
            if (p.startsWith(XPathAttributePrefix)) {
                isAttribute = true;
                p = p.substring(XPathAttributePrefix.length());
            }
            UniversalName pathEntry = PropertyPathConverter.convertQNameStringToUniversalName(p, node);
            if (isAttribute) {
                if (pathEntry.equals(new UniversalName(null, "srsName"))) {
                    addSrsName = true;
                    continue;
                }
                path.addAttribute(pathEntry);
                continue;
            }
            path.add(pathEntry);
        }
        try {
            columnName = ColumnNameFactory.createColumnName(path, storage);
            if (addSrsName) {
                columnName = ColumnNameFactory.getColumnName(columnName, "_srs_name_");
            }
        }
        catch (StorageException e) {
            throw new XMLParseErrorException(e.getMessage(), e);
        }
        return columnName;
    }

    protected static UniversalName convertQNameStringToUniversalName(String qNameString, Node node) throws XMLParseErrorException {
        QName qName = new QName(qNameString);
        if (!qName.isValid()) {
            throw new XMLParseErrorException("invalid QName [" + qNameString + "]");
        }
        String ns = NodeUtil.lookupNamespaceURI(node, qName.getPrefix());
        if (qName.getPrefix() != null && ns == null) {
            throw new XMLParseErrorException("unbounded prefix [" + qName.getPrefixForPrint() + "]" + " of QName [" + qNameString + "]");
        }
        return new UniversalName(ns, qName.getLocalName());
    }
}

