/*
 * Decompiled with CFR 0.152.
 */
package daruma.util;

import daruma.util.PropertyReader;
import daruma.xml.util.XMLFormatConverter;
import java.net.URL;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.w3c.dom.Element;

public class LogWriter {
    private static Logger logger = null;
    private static boolean isVerboseMode = false;
    private static boolean initialized = false;
    private static final String LOG_NAME = "daruma.log.name";

    private static void initialize() {
        String log_name = PropertyReader.getProperty(LOG_NAME);
        logger = Logger.getLogger((String)log_name);
        PropertyConfigurator.configure((String)PropertyReader.getFileName());
        initialized = true;
    }

    public static void initialize(URL url) {
        String log_name = PropertyReader.getProperty(LOG_NAME);
        logger = Logger.getLogger((String)log_name);
        PropertyConfigurator.configure((URL)url);
        initialized = true;
    }

    private static boolean ensureInitialized() {
        if (!initialized) {
            LogWriter.initialize();
            initialized = true;
        }
        return logger != null;
    }

    public static void setVerbose() {
        isVerboseMode = true;
    }

    public static synchronized void write(String str) {
        if (!LogWriter.ensureInitialized()) {
            return;
        }
        LogWriter.write("DEBUG", str);
    }

    public static synchronized void write(String level, String str) {
        if (!LogWriter.ensureInitialized()) {
            return;
        }
        if (level == null) {
            level = "DEBUG";
        }
        System.err.println(level + ":" + str);
        if (level.equalsIgnoreCase("ERROR")) {
            logger.error((Object)str);
        } else if (level.equalsIgnoreCase("WARN")) {
            logger.warn((Object)str);
        } else if (level.equalsIgnoreCase("INFO")) {
            logger.info((Object)str);
        } else if (level.equalsIgnoreCase("DEBUG")) {
            logger.debug((Object)str);
        } else if (level.equalsIgnoreCase("FATAL")) {
            logger.fatal((Object)str);
        } else {
            System.err.println("Missing/Unknown log level at LogWriter::write():level=" + level);
        }
    }

    public static void qwrite(String level, Object ... args) {
        try {
            if (LogWriter.isEnabled(level)) {
                StringBuilder logstr = new StringBuilder();
                for (Object obj : args) {
                    if (obj instanceof Element) {
                        logstr.append(XMLFormatConverter.toString((Element)obj));
                        continue;
                    }
                    logstr.append(obj);
                }
                LogWriter.write(level, logstr.toString());
            }
        }
        catch (TransformerException ex) {
            System.err.println("Fatal!!. Something wrong to convert XML node to String.\nobjs=");
            for (Object obj : args) {
                System.err.println(obj.toString());
            }
            ex.printStackTrace(System.err);
            throw new RuntimeException();
        }
    }

    public static boolean isEnabled(String level) {
        if (!LogWriter.ensureInitialized()) {
            return false;
        }
        if (isVerboseMode) {
            return true;
        }
        if (level.equalsIgnoreCase("ERROR")) {
            return logger.isEnabledFor((Priority)Level.ERROR);
        }
        if (level.equalsIgnoreCase("WARN")) {
            return logger.isEnabledFor((Priority)Level.WARN);
        }
        if (level.equalsIgnoreCase("INFO")) {
            return logger.isEnabledFor((Priority)Level.INFO);
        }
        if (level.equalsIgnoreCase("DEBUG")) {
            return logger.isEnabledFor((Priority)Level.DEBUG);
        }
        if (level.equalsIgnoreCase("FATAL")) {
            return logger.isEnabledFor((Priority)Level.FATAL);
        }
        System.err.println("Missing/Unknown log level at LogWriter::write():level=" + level + ".");
        return false;
    }
}

