/*
 * Decompiled with CFR 0.152.
 */
package daruma.server;

import daruma.auth.AuthenticationInfo;
import daruma.global_switch.ImplementationSwitches;
import daruma.server.ConnectionHandler;
import daruma.server.ConnectionInfoHolder;
import daruma.server.DarumaDaemonAdministrator;
import daruma.server.DarumaVersion;
import daruma.sql.DatabaseConnectionException;
import daruma.sql.MySQLDatabaseConnectionFactory;
import daruma.sql.PostgreSQLDatabaseConnectionFactory;
import daruma.util.FatalException;
import daruma.util.Itk;
import daruma.util.LogWriter;
import daruma.util.PortNumberValidator;
import daruma.util.PropertyReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class DarumaDaemon {
    public static final int DEFAULT_PORT = PropertyReader.getProperty("daruma.serv.port", 5050);
    public static final int DEFAULT_ADMIN_PORT = PropertyReader.getProperty("daruma.serv.admin_port", 5051);
    public static final boolean DEFAULT_USE_ADMIN_PORT = PropertyReader.getProperty("daruma.serv.use_admin_port", true);
    public static final boolean ADMIN_PORT_PRINT_USAGE = PropertyReader.getProperty("daruma.serv.admin_port_print_usage", false);
    public static final String DEFAULT_DATABASE_NAME = "daruma$devel";
    public static final String DEFAULT_USER = PropertyReader.getProperty("daruma.db.uid", "daruma");
    public static final String DEFAULT_PASSWORD = PropertyReader.getProperty("daruma.db.pass", "");
    public static final String DEFAULT_CONNECTION_LOG_DIRECTORY = ".";
    private int port;
    private String databaseName;
    private String user;
    private String password;
    private boolean debug;
    private boolean useGzipForReceiving;
    private boolean useGzipForSending;
    private boolean connectionLog;
    private File connectionLogDirectory;
    private boolean useAdminPort;
    private int adminPort;
    private DarumaDaemonAdministrator admin;
    private ServerSocket socket;
    private boolean isShuttingDown;
    private long connectionID;
    private ConnectionInfoHolder connectionInfoHandler = new ConnectionInfoHolder();

    public ConnectionInfoHolder getConnectionInfoHolder() {
        return this.connectionInfoHandler;
    }

    public DarumaDaemon(int port, String databaseName, String user, String password, boolean useGzipForReceiving, boolean useGzipForSending, boolean useAdminPort, int adminPort) {
        this.port = port;
        this.debug = false;
        this.useGzipForReceiving = useGzipForReceiving;
        this.useGzipForSending = useGzipForSending;
        this.connectionLog = false;
        this.connectionLogDirectory = null;
        this.databaseName = databaseName;
        this.user = user;
        this.password = password;
        this.useAdminPort = useAdminPort;
        this.adminPort = adminPort;
        this.socket = null;
        this.isShuttingDown = false;
        this.connectionID = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run() {
        block28: {
            if (this.checkConfig()) break block28;
            boolean bl = false;
            if (this.socket == null) return bl;
            try {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close:", this.socket);
                this.socket.close();
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        this.socket = new ServerSocket(this.port);
        this.socket.setReuseAddress(true);
        if (this.useAdminPort) {
            this.admin = new DarumaDaemonAdministrator(this, this.adminPort, ADMIN_PORT_PRINT_USAGE);
            new Thread(this.admin).start();
        }
        LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Listen:", this.socket);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                DarumaDaemon.this.admin.shutdown();
                DarumaDaemon.this.shutdown();
            }
        });
        while (true) {
            ConnectionHandler c;
            Socket s;
            block29: {
                if (ImplementationSwitches.instance().getDoFullGC()) {
                    Runtime.getRuntime().gc();
                }
                if (this.isShuttingDown) break;
                s = null;
                try {
                    s = this.socket.accept();
                }
                catch (SocketException e) {
                    if (this.isShuttingDown) break block29;
                    throw e;
                }
            }
            if (this.isShuttingDown) {
                if (s == null) break;
                try {
                    s.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            try {
                c = new ConnectionHandler(this, s, s.getInputStream(), s.getOutputStream(), new AuthenticationInfo(), this.databaseName, this.user, this.password, this.useGzipForReceiving, this.useGzipForSending, s.toString(), this.debug, this.connectionLog, this.connectionLogDirectory, this.connectionID);
                ++this.connectionID;
            }
            catch (DatabaseConnectionException e) {
                LogWriter.qwrite("ERROR", e.getMessage());
                continue;
            }
            catch (SocketException e) {
                LogWriter.qwrite("INFO", e.getMessage());
                e.printStackTrace();
                continue;
            }
            Thread th = new Thread(c);
            th.start();
        }
        if (this.socket == null) return true;
        try {
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close:", this.socket);
            this.socket.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (BindException e) {
            LogWriter.qwrite("ERROR", "Can't bind server socket: ", e.getMessage());
            System.err.println("Can't bind server socket: " + e.getMessage());
            boolean bl = false;
            if (this.socket == null) return bl;
            try {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close:", this.socket);
                this.socket.close();
                return bl;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return false;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            boolean bl = false;
            if (this.socket == null) return bl;
            {
                catch (Throwable throwable) {
                    if (this.socket == null) throw throwable;
                    try {
                        LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close:", this.socket);
                        this.socket.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                        return false;
                    }
                }
            }
            try {
                LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close:", this.socket);
                this.socket.close();
                return bl;
            }
            catch (IOException e4) {
                e4.printStackTrace();
                return false;
            }
        }
    }

    private boolean checkConfig() {
        if (!PortNumberValidator.check(this.port)) {
            LogWriter.qwrite("ERROR", "configuration error: ", "invalid port number: ", this.port);
            System.err.println("invalid port number: " + this.port);
            return false;
        }
        if (!PortNumberValidator.check(this.adminPort)) {
            LogWriter.qwrite("ERROR", "configuration error: ", "invalid admin port number: ", this.adminPort);
            System.err.println("invalid admin port number: " + this.adminPort);
            return false;
        }
        return true;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConnectionLog(boolean connectionLog, File connectionLogDirectory) {
        this.connectionLog = connectionLog;
        this.connectionLogDirectory = connectionLogDirectory;
    }

    public void shutdown() {
        if (this.isShuttingDown) {
            return;
        }
        this.isShuttingDown = true;
        try {
            LogWriter.qwrite("INFO", "[" + Itk.getCurrentTimeStr() + "] ", "Close:", this.socket);
            this.socket.close();
            this.socket = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws FatalException {
        File connectionLogDirectory;
        DarumaDaemonOptionAnalyzer opt;
        block17: {
            opt = new DarumaDaemonOptionAnalyzer(args, "DarumaDaemon", DEFAULT_PORT, DEFAULT_DATABASE_NAME, DEFAULT_USER, DEFAULT_PASSWORD, DEFAULT_CONNECTION_LOG_DIRECTORY, DEFAULT_USE_ADMIN_PORT, DEFAULT_ADMIN_PORT);
            if (!opt.analyze()) {
                opt.printHelp(System.err);
                System.exit(1);
            } else if (opt.getHelp()) {
                opt.printHelp(System.out);
                System.exit(0);
            } else if (opt.getVersion()) {
                System.out.println(DarumaVersion.getVersion());
                System.exit(0);
            }
            if (opt.getDebug()) {
                LogWriter.setVerbose();
            }
            ImplementationSwitches.createInstance();
            connectionLogDirectory = new File(opt.getConnectionLogDirectory());
            if (opt.getConnectionLog()) {
                String err;
                if (connectionLogDirectory.exists()) {
                    if (!connectionLogDirectory.isDirectory()) {
                        err = "connection log directory [" + connectionLogDirectory + "] is not a directory";
                        System.err.println(err);
                        LogWriter.qwrite("FATAL", err);
                        System.exit(1);
                    }
                } else if (!connectionLogDirectory.mkdirs()) {
                    err = "Can't create connection log directory [" + connectionLogDirectory + "]";
                    System.err.println(err);
                    LogWriter.qwrite("FATAL", err);
                    System.exit(1);
                }
            }
            try {
                if (ImplementationSwitches.instance().isPostGISBackend()) {
                    new PostgreSQLDatabaseConnectionFactory().loadClass();
                    break block17;
                }
                if (ImplementationSwitches.instance().isMySQLBackend()) {
                    new MySQLDatabaseConnectionFactory(ImplementationSwitches.instance().getMySQLHost(), ImplementationSwitches.instance().getMySQLPort()).create();
                    break block17;
                }
                throw new RuntimeException("Unknown backend DBMS");
            }
            catch (DatabaseConnectionException.ClassLoadFailedDatabaseConnectionException e) {
                LogWriter.qwrite("FATAL", "Can't load class: " + e.getFailedClassName());
                throw new RuntimeException("Can't load class: " + e.getFailedClassName());
            }
            catch (DatabaseConnectionException dce) {
                LogWriter.qwrite("FATAL", "Can't load DB class");
                throw new RuntimeException("Can't load DB class: " + dce.getMessage());
            }
        }
        DarumaDaemon daemon = new DarumaDaemon(opt.getPortNumber(), opt.getDatabaseName(), opt.getUser(), opt.getPassword(), opt.getGzipReceive(), opt.getGzipSend(), opt.getUseAdminPort(), opt.getAdminPortNumber());
        daemon.setDebug(opt.getDebug());
        daemon.setConnectionLog(opt.getConnectionLog(), connectionLogDirectory);
        if (!daemon.run()) {
            System.exit(1);
        }
    }

    public static class DarumaDaemonOptionAnalyzer {
        private String[] args;
        private String programName;
        private int portNumber;
        private String databaseName;
        private String user;
        private String password;
        private boolean useAdminPort;
        private int adminPortNumber;
        private boolean helpFlag = false;
        private boolean versionFlag = false;
        private boolean debugFlag = false;
        private boolean connectionLogFlag = false;
        private String connectionLogDirectory = null;
        private boolean gzipReceiveFlag = false;
        private boolean gzipSendFlag = false;

        public DarumaDaemonOptionAnalyzer(String[] args, String programName, int defaultPortNumber, String defaultDatabaseName, String defaultUser, String defaultPassword, String defaultConnectionLogDirectory, boolean defaultUseAdminPort, int defaultAdminPortNumber) {
            this.args = (String[])args.clone();
            this.programName = programName;
            this.portNumber = defaultPortNumber;
            this.databaseName = defaultDatabaseName;
            this.user = defaultUser;
            this.password = defaultPassword;
            this.useAdminPort = defaultUseAdminPort;
            this.adminPortNumber = defaultAdminPortNumber;
            this.connectionLogFlag = false;
            this.connectionLogDirectory = defaultConnectionLogDirectory;
        }

        public boolean analyze() {
            for (int index = 0; index < this.args.length; ++index) {
                String arg = this.args[index];
                int numArgs = this.args.length - index - 1;
                if (arg.equals("--help")) {
                    this.helpFlag = true;
                    continue;
                }
                if (arg.equals("--version")) {
                    this.versionFlag = true;
                    continue;
                }
                if (arg.equals("--port")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.portNumber = this.parsePortNumber(this.args[index + 1]);
                    if (this.portNumber < 0) {
                        return false;
                    }
                    ++index;
                    continue;
                }
                if (arg.equals("--database")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.databaseName = this.args[index + 1];
                    ++index;
                    continue;
                }
                if (arg.equals("--user")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.user = this.args[index + 1];
                    ++index;
                    continue;
                }
                if (arg.equals("--password")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.password = this.args[index + 1];
                    ++index;
                    continue;
                }
                if (arg.equals("--debug")) {
                    this.debugFlag = true;
                    continue;
                }
                if (arg.equals("--gzip")) {
                    this.gzipReceiveFlag = true;
                    this.gzipSendFlag = true;
                    continue;
                }
                if (arg.equals("--gzip-receive")) {
                    this.gzipReceiveFlag = true;
                    continue;
                }
                if (arg.equals("--gzip-send")) {
                    this.gzipSendFlag = true;
                    continue;
                }
                if (arg.equals("--connection-log")) {
                    this.connectionLogFlag = true;
                    continue;
                }
                if (arg.equals("--connection-log-directory")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.connectionLogDirectory = this.args[++index];
                    continue;
                }
                if (arg.equals("--use-admin-port")) {
                    this.useAdminPort = true;
                    continue;
                }
                if (arg.equals("--admin-port")) {
                    if (numArgs < 1) {
                        return false;
                    }
                    this.adminPortNumber = this.parsePortNumber(this.args[index + 1]);
                    if (this.adminPortNumber < 0) {
                        return false;
                    }
                    ++index;
                    continue;
                }
                LogWriter.qwrite("invalid option: " + arg, new Object[0]);
                System.err.println("invalid option: " + arg);
                return false;
            }
            return true;
        }

        private int parsePortNumber(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LogWriter.qwrite("ERROR", "invalid port number: ", value);
                System.err.println("invalid port number: " + value);
                return -1;
            }
        }

        public void printHelp(OutputStream out) {
            String mes = "";
            mes = mes + "Usage: " + this.programName + " [options]" + "\n";
            mes = mes + "Possible options are:\n";
            mes = mes + "      --help\n";
            mes = mes + "      --version\n";
            mes = mes + "      --port PORT\n";
            mes = mes + "      --use-admin-port\n";
            mes = mes + "      --admin-port PORT\n";
            mes = mes + "      --database DATABASE_NAME\n";
            mes = mes + "      --user USER_NAME\n";
            mes = mes + "      --password PASSWORD\n";
            mes = mes + "      --debug\n";
            mes = mes + "      --connection-log\n";
            mes = mes + "      --connection-log-directory DIRECTORY\n";
            mes = mes + "      --gzip\n";
            mes = mes + "      --gzip-receive\n";
            mes = mes + "      --gzip-send\n";
            PrintStream p = new PrintStream(out);
            p.print(mes);
        }

        public boolean getHelp() {
            return this.helpFlag;
        }

        public boolean getVersion() {
            return this.versionFlag;
        }

        public int getPortNumber() {
            return this.portNumber;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean getDebug() {
            return this.debugFlag;
        }

        public boolean getGzipReceive() {
            return this.gzipReceiveFlag;
        }

        public boolean getGzipSend() {
            return this.gzipSendFlag;
        }

        public boolean getConnectionLog() {
            return this.connectionLogFlag;
        }

        public String getConnectionLogDirectory() {
            return this.connectionLogDirectory;
        }

        public boolean getUseAdminPort() {
            return this.useAdminPort;
        }

        public int getAdminPortNumber() {
            return this.adminPortNumber;
        }
    }
}

