/*
 * Decompiled with CFR 0.152.
 */
package mispClient.commands;

import daruma.storage_manager.type_definition.ElementName;
import daruma.xml.SimpleXPath;
import daruma.xml.URI;
import daruma.xml.UniversalName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import mispClient.MispCommand;
import mispClient.MispCommandException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import xmlUtil.SimpleXPathXSAXHandler;
import xmlUtil.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeFeatureTypeMispCommand
extends MispCommand {
    private static final String DESCRIBE_FEATURE_TYPE_ELEMENT_NAME = "DescribeFeatureType";
    private static final String TYPE_NAME_ELEMENT_NAME = "TypeName";
    private static final String DESCRIBE_FEATURE_TYPE_RESPONSE_ELEMENT_NAME = "DescribeFeatureTypeResponse";
    private static final String SCHEMA_ELEMENT_NAME = "schema";
    private final List<ElementName> features;
    private Document resultDocument;
    private OutputStream out;
    private String encoding;

    public DescribeFeatureTypeMispCommand(List<ElementName> features, OutputStream out, String encoding) {
        this.features = new ArrayList<ElementName>(features);
        this.resultDocument = null;
        this.out = out;
        this.encoding = encoding;
    }

    @Override
    public InputStream getInputStream() {
        StringBuilder buf = new StringBuilder();
        buf.append("<misp:DescribeFeatureType xmlns:misp=\"" + URI.MISP + "\">\n");
        for (ElementName f : this.features) {
            buf.append("  <misp:TypeName xmlns=\"" + f.getNamespace() + "\">");
            try {
                buf.append(new String(f.getLocalName().getBytes(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            buf.append("</misp:TypeName>\n");
        }
        buf.append("</misp:DescribeFeatureType>\n");
        return new ByteArrayInputStream(buf.toString().getBytes());
    }

    @Override
    public void processResponse(InputStream in) throws MispCommandException {
        SimpleXPath path = new SimpleXPath();
        path.add(new UniversalName(URI.MISP, DESCRIBE_FEATURE_TYPE_RESPONSE_ELEMENT_NAME));
        path.add(new UniversalName(URI.XML_SCHEMA, SCHEMA_ELEMENT_NAME));
        try {
            XMLReader parser = XMLUtil.createSAXParser();
            SimpleXPathXSAXHandler handler = new SimpleXPathXSAXHandler(path, this.out, this.encoding, parser, false);
            XMLUtil.handleXMLInputStream(handler, parser, in);
        }
        catch (SAXException e) {
            throw new MispCommandException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MispCommandException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MispCommandException(e.getMessage(), e);
        }
    }
}

