#ifndef	   LINE_BUFFER_BINARY_SIZE_WRAPPER_OUTPUT_H_INCLUDED
#define	   LINE_BUFFER_BINARY_SIZE_WRAPPER_OUTPUT_H_INCLUDED

// Author:		H. Shimora
// Created:		Mar  4 2007
// Version:		0.00

///-----------------------------------------------
/// Change Log:
///-----------------------------------------------
// version 0.00  Mar  4 2007    base version.
//
//

#include  "abstract_output.h"
#include  <string>

class  Line_Buffer_Binary_Size_Wrapper_Output : public Abstract_Output
{
private:
	const ref_count_ptr<Abstract_Output>	out;
	std::string				buffer;

public:
	Line_Buffer_Binary_Size_Wrapper_Output
		( const ref_count_ptr<Abstract_Output>  &  out )
		: out( out )
	{
	}

	virtual	~Line_Buffer_Binary_Size_Wrapper_Output()
	{
	}

	virtual	bool	output_valid() const
	{
		return( this -> out -> output_valid() );
	}

	virtual	int	write( const unsigned char * const  buf ,
			       size_t  size )
	{
		for ( size_t  i = 0  ;  i < size  ;  ++ i )
		{
			this -> buffer.append( 1 , buf[i] );

			if ( buf[i] == '\n' )
			{
				size_t	data_size = this -> buffer.size();
				int	n_wrote = 0;

				uint32_t  data_size_buf = ::htonl(data_size);

				if ( this -> out -> write
				     ( reinterpret_cast<const unsigned char *>
				       ( &data_size_buf ) ,
				       sizeof( data_size_buf ) ) == -1 )
				{
					std::cerr << "failed #" << std::endl;
				}

				while( static_cast<size_t>( n_wrote )
				       < data_size )
				{
					int	n;
					n = this -> out -> write
					    ( static_cast
					      <const unsigned char *>
					      ( static_cast
						<const void *>
						( this -> buffer.data()
						  + n_wrote ) ) ,
					      this -> buffer.size()
						      - n_wrote );

					if ( n == -1 )
					{
						return( -1 );
					}
					else
					{
						n_wrote += n;
					}
				}

				this -> buffer.clear();
			}
		}

		return( static_cast<int>(size) );

	}

	virtual	bool	output_eof() const
	{
		return( this -> out -> output_eof() );
	}

	virtual	bool	output_close()
	{
		return( this -> out -> output_close() );
	}
};

#endif	/* LINE_BUFFER_BINARY_SIZE_WRAPPER_OUTPUT_H_INCLUDED */
