#ifndef	   COMBINATION_IO_H_INCLUDED
#define	   COMBINATION_IO_H_INCLUDED

// Author:		H. Shimora
// Created:		Dec  3 2002
// Version:		0.00

//------------------------------------------------
// Change Log:
//------------------------------------------------
// version 0.00  Dec  3 2002    base version.
//
//

#include  "abstract_io.h"
#include  "ref_count_ptr.h"

class  Combination_IO : public Abstract_IO
{
private:
	const ref_count_ptr<Abstract_Input>	in;
	const ref_count_ptr<Abstract_Output>	out;

public:
	Combination_IO( const ref_count_ptr<Abstract_Input>  &  in ,
			const ref_count_ptr<Abstract_Output> &  out )
		: in( in ) , out( out )
	{
	}

	virtual	~Combination_IO()
	{
	}

	virtual	bool	input_valid() const
	{
		return( this -> in -> input_valid() );
	}

	virtual	bool	output_valid() const
	{
		return( this -> out -> output_valid() );
	}

	virtual	int	read( unsigned char *  buf ,  size_t  size )
	{
		return( this -> in -> read( buf , size ) );
	}

	virtual	int	write( const unsigned char * const  buf ,
			       size_t  size )
	{
		return( this -> out -> write( buf , size ) );
	}

	virtual	bool	input_eof() const
	{
		return( this -> in -> input_eof() );
	}

	virtual	bool	output_eof() const
	{
		return( this -> out -> output_eof() );
	}

	virtual	bool	input_poll() const
	{
		return( this -> in -> input_poll() );
	}

	virtual	std::vector<int>	input_fds() const
	{
		return( this -> in -> input_fds() );
	}

	virtual	bool	input_close()
	{
		return( this -> in -> input_close() );
	}

	virtual	bool	output_close()
	{
		return( this -> out -> output_close() );
	}
};


#endif	/* COMBINATION_IO_H_INCLUDED */
