/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2009  Kouhei Sutou <kou@clear-code.com>
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "cppcut-assertions-helper.h"

void
cut::assert_equal(int expected, int actual,
                  const char *expression_expected,
                  const char *expression_actual)
{
    cut::assert_equal_reference(expected, actual,
                                expression_expected, expression_actual);
}

void
cut::assert_equal(unsigned int expected, unsigned int actual,
                  const char *expression_expected,
                  const char *expression_actual)
{
    cut::assert_equal_reference(expected, actual,
                                expression_expected, expression_actual);
}

void
cut::assert_equal(long expected, long actual,
                  const char *expression_expected,
                  const char *expression_actual)
{
    cut::assert_equal_reference(expected, actual,
                                expression_expected, expression_actual);
}

void
cut::assert_equal(unsigned long expected, unsigned long actual,
                  const char *expression_expected,
                  const char *expression_actual)
{
    cut::assert_equal_reference(expected, actual,
                                expression_expected, expression_actual);
}

void
cut::assert_equal(long long expected, long long actual,
                  const char *expression_expected,
                  const char *expression_actual)
{
    cut::assert_equal_reference(expected, actual,
                                expression_expected, expression_actual);
}

void
cut::assert_equal(unsigned long long expected, unsigned long long actual,
                  const char *expression_expected,
                  const char *expression_actual)
{
    cut::assert_equal_reference(expected, actual,
                                expression_expected, expression_actual);
}

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
