/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * LunchOrderFormのResultDataです。 <BR>
 * 
 */
public class LunchOrderPreViewResultData implements ALData {

  /**hiddenパラメータ*/
  private ALStringField itemId;

  /** お弁当名 */
  private ALStringField itemName;

  /** 価格 */
  private ALStringField itemPrice;

  /** コメント */
  private ALStringField itemComment;
  
  /**フラグ*/
  private ALStringField itemMinOrderFlag;

  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    itemId = new ALStringField();
    itemName = new ALStringField();
    itemPrice = new ALStringField();
    itemComment = new ALStringField();
itemMinOrderFlag = new ALStringField();
  }

  public ALStringField getItemId() {
    return itemId;
  }

  public void setItemId(String string) {
    itemId.setValue(string);
  }

  public ALStringField getItemName() {
    return itemName;
  }

  public void setItemName(String string) {
    itemName.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getItemPrice() {
    return itemPrice;
  }

  /**
   * @param i
   */
  public void setItemPrice(String string) {
    itemPrice.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getItemComment() {
    return itemComment;
  }

  /**
   * @param string
   */
  public void setItemComment(String string) {
    itemComment.setValue(string);
  }

  public ALStringField getItemMinOrderFlag() {
    return itemMinOrderFlag;
  }

  public void setItemMinOrderFlag(String string) {
    itemMinOrderFlag.setValue(string);
  }

  
}
