/***************************************************************/
/** ATTENTION PLEASE: THIS JS DEPEND ON ajaxtags-1.2-beta1.js **/
/**                                             @author Bato  **/
/***************************************************************/

ResponseXmlMultiParser = Class.create();
ResponseXmlMultiParser.prototype = Object.extend(new AbstractResponseParser(), {
  initialize: function() {
    this.type = "xml";
  },

  load: function(request) {
    this.content = request.responseXML;
    this.parse();
  },

  parse: function() {
    var root = this.content.documentElement;
    var responseNodes = root.getElementsByTagName("response");
    this.targetList = new Array();
    if (responseNodes.length > 0) {
      var responseNode = responseNodes[0];
      var targetNodes = responseNode.getElementsByTagName("target");
      for (var j=0; j<targetNodes.length; j++) { /* target node */
        var itemNodes = targetNodes[j].getElementsByTagName("item");
        var tagname = targetNodes[j].getAttribute("tagname");
        var type = targetNodes[j].getAttribute("type");
        var id = targetNodes[j].getAttribute("id");
        var itemList = new Array();
        for (var i=0; i<itemNodes.length; i++) { /* item node */
          var nameNodes = itemNodes[i].getElementsByTagName("name");
          var valueNodes = itemNodes[i].getElementsByTagName("value");
          if (nameNodes.length > 0 && valueNodes.length > 0) {
            var name = nameNodes[0].firstChild.nodeValue;
            var value = valueNodes[0].firstChild.nodeValue;
            itemList.push(new Array(name, value));
          }
        }
        this.targetList.push(new Array(itemList,tagname,type,id));
      }
    }
  }
});

AjaxJspTag.AmpiereCallout = Class.create();
AjaxJspTag.AmpiereCallout.prototype = Object.extend(new AjaxJspTag.Base(), {

  initialize: function(url, options) {
    this.url = url;
    this.setOptions(options);
    this.setListeners();
  },

  setOptions: function(options) {
    this.options = Object.extend({
      parameters: options.parameters || '',
      eventType: options.eventType ? options.eventType : "change",
      parser: options.parser ? options.parser : new ResponseXmlMultiParser(),
      handler: options.handler ? options.handler : this.handler
    }, options || {});
  },

  setListeners: function() {
    eval("$(this.options.source).on"+this.options.eventType+" = this.execute.bindAsEventListener(this)");
  },

  execute: function(e) {
    if (this.options.preFunction != null) this.options.preFunction();

    // parse parameters and do replacements
    var params = buildParameterString(this.options.parameters);

    var obj = this; // required because 'this' conflict with Ajax.Request
    var aj = new Ajax.Request(this.url, {
      asynchronous: true,
      method: 'get',
      parameters: params,
      onSuccess: function(request) {
        obj.options.parser.load(request);
        var results = obj.options.parser.targetList;
        obj.options.handler(request, results);
      },
      onFailure: function(request) {
        if (obj.options.errorFunction != null) obj.options.errorFunction(request);
      },
      onComplete: function(request) {
        if (obj.options.postFunction != null) obj.options.postFunction(request);
      }
    });
  },

  handler: function(request, results) {
    
    for(var i = 0; i < results.length; i++){
      var target = {
          itemlist: results[i][0],
          tagname: results[i][1],
          type: results[i][2],
          id: results[i][3]
      };

      var t_targetobj = $(target.id);
      switch (target.tagname) {
        case 'select': /* If the select tag */
          t_targetobj.options.length = 0;
          //$(targetID).disabled = false;
          for (var ii=0; ii<target.itemlist.length; ii++) {
            t_targetobj.options[ii] = new Option(target.itemlist[ii][0], target.itemlist[ii][1]);
          }
          break;
        case 'input': /* If the input tag */
          switch (target.type) {
            case 'file' :
              /* we do not anything on type file because SECURITY problem */
              break;
            case 'button' :
            case 'reset' :
            case 'submit' :
            case 'text' :
            case 'password' :
            case 'hidden' :
            default:
              t_targetobj.value = target.itemlist[0][0];
              break;
            case 'checkbox' :
            case 'radio' :
              if (target.itemlist[0][0] == "true" )
                t_targetobj.checked = true;
              else
                t_targetobj.checked = false;
              break;
          }
          break;
        case 'textarea':
          t_targetobj.value = target.itemlist[0][0];
          break;
        default:
          t_targetobj.innerHTML = target.itemlist[0][0];
          break;
      }
    }
  },
  update: function(){}
});
